/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.converters.StringListConverter;
import com.github.joschi.jadconfig.validators.InetPortValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.ServerAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbConfiguration.class);
    @Parameter(value="mongodb_useauth")
    @Deprecated
    private boolean useAuth = false;
    @Parameter(value="mongodb_user")
    @Deprecated
    private String user;
    @Parameter(value="mongodb_password")
    @Deprecated
    private String password;
    @Parameter(value="mongodb_database")
    @Deprecated
    private String database = "graylog2";
    @Parameter(value="mongodb_host")
    @Deprecated
    private String host = "127.0.0.1";
    @Parameter(value="mongodb_port", validator=InetPortValidator.class)
    @Deprecated
    private int port = 27017;
    @Parameter(value="mongodb_max_connections", validator=PositiveIntegerValidator.class)
    private int maxConnections = 1000;
    @Parameter(value="mongodb_threads_allowed_to_block_multiplier", validator=PositiveIntegerValidator.class)
    private int threadsAllowedToBlockMultiplier = 5;
    @Parameter(value="mongodb_replica_set", converter=StringListConverter.class)
    @Deprecated
    private List<String> replicaSet;
    @Parameter(value="mongodb_uri")
    private String uri = null;

    @Deprecated
    public boolean isUseAuth() {
        return this.useAuth;
    }

    @Deprecated
    public String getUser() {
        return this.user;
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }

    @Deprecated
    public String getDatabase() {
        return this.database;
    }

    @Deprecated
    public int getPort() {
        return this.port;
    }

    @Deprecated
    public String getHost() {
        return this.host;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getThreadsAllowedToBlockMultiplier() {
        return this.threadsAllowedToBlockMultiplier;
    }

    public String getUri() {
        return this.uri;
    }

    public MongoClientURI getMongoClientURI() {
        if (Strings.isNullOrEmpty((String)this.uri)) {
            List<ServerAddress> replicas;
            StringBuilder sb = new StringBuilder("mongodb://");
            if (this.isUseAuth()) {
                sb.append(this.getUser()).append(':').append(this.getPassword()).append('@');
            }
            if ((replicas = this.getReplicaSet()) == null) {
                sb.append(this.getHost()).append(':').append(this.getPort());
            } else {
                Joiner.on((char)',').skipNulls().appendTo(sb, replicas);
            }
            sb.append('/').append(this.getDatabase());
            this.uri = sb.toString();
        }
        MongoClientOptions.Builder mongoClientOptionsBuilder = MongoClientOptions.builder().connectionsPerHost(this.getMaxConnections()).threadsAllowedToBlockForConnectionMultiplier(this.getThreadsAllowedToBlockMultiplier());
        return new MongoClientURI(this.uri, mongoClientOptionsBuilder);
    }

    @Deprecated
    public List<ServerAddress> getReplicaSet() {
        if (this.replicaSet == null || this.replicaSet.isEmpty()) {
            return null;
        }
        ArrayList<ServerAddress> replicaServers = new ArrayList<ServerAddress>(this.replicaSet.size());
        for (String host : this.replicaSet) {
            try {
                HostAndPort hostAndPort = HostAndPort.fromString((String)host).withDefaultPort(27017);
                replicaServers.add(new ServerAddress(InetAddress.getByName(hostAndPort.getHostText()), hostAndPort.getPort()));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Malformed mongodb_replica_set configuration.", (Throwable)e);
                return null;
            }
            catch (UnknownHostException e) {
                LOG.error("Unknown host in mongodb_replica_set", (Throwable)e);
                return null;
            }
        }
        return replicaServers;
    }

    @ValidatorMethod
    public void validate() throws ValidationException {
        if ((Strings.isNullOrEmpty((String)this.getHost()) || Strings.isNullOrEmpty((String)this.getDatabase())) && Strings.isNullOrEmpty((String)this.getUri())) {
            throw new ValidationException("Either mongodb_uri OR mongodb_host and mongodb_database must not be empty");
        }
        if (Strings.isNullOrEmpty((String)this.getUri())) {
            LOG.info("You're using deprecated configuration options for MongoDB. Please use mongodb_uri.");
            LOG.info("Suggested value for mongodb_uri = {}", (Object)this.getMongoClientURI());
        }
        if (this.isUseAuth() && (Strings.isNullOrEmpty((String)this.getUser()) || Strings.isNullOrEmpty((String)this.getPassword()))) {
            throw new ValidationException("mongodb_user and mongodb_password have to be set if mongodb_useauth is true");
        }
    }
}

