/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.FieldChartWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.QuickvaluesWidget;
import org.graylog2.dashboards.widgets.SearchResultChartWidget;
import org.graylog2.dashboards.widgets.SearchResultCountWidget;
import org.graylog2.dashboards.widgets.StatisticalCountWidget;
import org.graylog2.dashboards.widgets.StreamSearchResultCountWidget;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.KeywordRange;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.database.EmbeddedPersistable;
import org.graylog2.rest.models.dashboards.requests.AddWidgetRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class DashboardWidget
implements EmbeddedPersistable {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_CACHE_TIME = "cache_time";
    private static final String FIELD_CREATOR_USER_ID = "creator_user_id";
    private static final String FIELD_CONFIG = "config";
    public static final int DEFAULT_CACHE_TIME = 10;
    private final MetricRegistry metricRegistry;
    private final Type type;
    private final String id;
    private final Map<String, Object> config;
    private final String creatorUserId;
    private int cacheTime;
    private String description;
    private Supplier<ComputationResult> cachedResult;

    protected DashboardWidget(MetricRegistry metricRegistry, Type type, String id, String description, int cacheTimeS, Map<String, Object> config, String creatorUserId) {
        this.metricRegistry = metricRegistry;
        this.type = type;
        this.id = id;
        this.config = config;
        this.creatorUserId = creatorUserId;
        this.description = description;
        this.cacheTime = cacheTimeS < 1 ? 10 : cacheTimeS;
        this.cachedResult = Suppliers.memoizeWithExpiration((Supplier)new ComputationResultSupplier(), (long)this.cacheTime, (TimeUnit)TimeUnit.SECONDS);
    }

    public static DashboardWidget fromRequest(MetricRegistry metricRegistry, Searches searches, AddWidgetRequest awr, String userId) throws NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        return DashboardWidget.fromRequest(metricRegistry, searches, null, awr, userId);
    }

    public static DashboardWidget fromRequest(MetricRegistry metricRegistry, Searches searches, String widgetId, AddWidgetRequest awr, String userId) throws NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        TimeRange timeRange;
        Type type;
        try {
            type = Type.valueOf(awr.type().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchWidgetTypeException("No such widget type <" + awr.type() + ">");
        }
        String id = Strings.isNullOrEmpty((String)widgetId) ? UUID.randomUUID().toString() : widgetId;
        String rangeType = (String)awr.config().get("range_type");
        if (rangeType == null) {
            throw new InvalidRangeParametersException("range_type not set");
        }
        switch (rangeType) {
            case "relative": {
                timeRange = new RelativeRange(Integer.parseInt((String)awr.config().get("range")));
                break;
            }
            case "keyword": {
                timeRange = new KeywordRange((String)awr.config().get("keyword"), true);
                break;
            }
            case "absolute": {
                timeRange = new AbsoluteRange((String)awr.config().get("from"), (String)awr.config().get("to"));
                break;
            }
            default: {
                throw new InvalidRangeParametersException("range_type not recognized");
            }
        }
        return DashboardWidget.buildDashboardWidget(type, metricRegistry, searches, id, awr.description(), 0, awr.config(), (String)awr.config().get("query"), timeRange, userId);
    }

    public static DashboardWidget fromPersisted(MetricRegistry metricRegistry, Searches searches, BasicDBObject fields) throws NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        TimeRange timeRange;
        Type type;
        try {
            type = Type.valueOf(((String)fields.get(FIELD_TYPE)).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchWidgetTypeException();
        }
        BasicDBObject config = (BasicDBObject)fields.get(FIELD_CONFIG);
        BasicDBObject timerangeConfig = (BasicDBObject)config.get("timerange");
        String rangeType = (String)timerangeConfig.get(FIELD_TYPE);
        if (rangeType == null) {
            throw new InvalidRangeParametersException("range type not set");
        }
        switch (rangeType) {
            case "relative": {
                timeRange = new RelativeRange((Integer)timerangeConfig.get("range"));
                break;
            }
            case "keyword": {
                timeRange = new KeywordRange((String)timerangeConfig.get("keyword"), true);
                break;
            }
            case "absolute": {
                String from = new DateTime(timerangeConfig.get("from"), DateTimeZone.UTC).toString("yyyy-MM-dd HH:mm:ss.SSS");
                String to = new DateTime(timerangeConfig.get("to"), DateTimeZone.UTC).toString("yyyy-MM-dd HH:mm:ss.SSS");
                timeRange = new AbsoluteRange(from, to);
                break;
            }
            default: {
                throw new InvalidRangeParametersException("range_type not recognized");
            }
        }
        String description = (String)fields.get(FIELD_DESCRIPTION);
        int cacheTime = (Integer)MoreObjects.firstNonNull((Object)fields.get(FIELD_CACHE_TIME), (Object)0);
        return DashboardWidget.buildDashboardWidget(type, metricRegistry, searches, (String)fields.get(FIELD_ID), description, cacheTime, (Map<String, Object>)config, (String)config.get("query"), timeRange, (String)fields.get(FIELD_CREATOR_USER_ID));
    }

    public static DashboardWidget buildDashboardWidget(Type type, MetricRegistry metricRegistry, Searches searches, String widgetId, String description, int cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) throws NoSuchWidgetTypeException, InvalidWidgetConfigurationException {
        switch (type) {
            case SEARCH_RESULT_COUNT: {
                return new SearchResultCountWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case STREAM_SEARCH_RESULT_COUNT: {
                return new StreamSearchResultCountWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case FIELD_CHART: {
                return new FieldChartWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case QUICKVALUES: {
                return new QuickvaluesWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case SEARCH_RESULT_CHART: {
                return new SearchResultChartWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case STATS_COUNT: {
                return new StatisticalCountWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
        }
        throw new NoSuchWidgetTypeException();
    }

    public Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCacheTime(int cacheTime) {
        this.cacheTime = cacheTime;
        this.cachedResult = Suppliers.memoizeWithExpiration((Supplier)new ComputationResultSupplier(), (long)this.cacheTime, (TimeUnit)TimeUnit.SECONDS);
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public Map<String, Object> getPersistedFields() {
        return ImmutableMap.builder().put((Object)FIELD_ID, (Object)this.id).put((Object)FIELD_TYPE, (Object)this.type.toString().toLowerCase()).put((Object)FIELD_DESCRIPTION, (Object)this.description).put((Object)FIELD_CACHE_TIME, (Object)this.cacheTime).put((Object)FIELD_CREATOR_USER_ID, (Object)this.creatorUserId).put((Object)FIELD_CONFIG, this.getPersistedConfig()).build();
    }

    public ComputationResult getComputationResult() throws ExecutionException {
        return (ComputationResult)this.cachedResult.get();
    }

    public abstract Map<String, Object> getPersistedConfig();

    protected abstract ComputationResult compute();

    private Timer getCalculationTimer() {
        return this.metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{this.getId(), "calculationTime"}));
    }

    private Meter getCalculationMeter() {
        return this.metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{this.getId(), "calculations"}));
    }

    private class ComputationResultSupplier
    implements Supplier<ComputationResult> {
        private ComputationResultSupplier() {
        }

        /*
         * Loose catch block
         */
        public ComputationResult get() {
            try {
                try (Timer.Context timer = DashboardWidget.this.getCalculationTimer().time();){
                    ComputationResult computationResult = DashboardWidget.this.compute();
                    return computationResult;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DashboardWidget.this.getCalculationMeter().mark();
            }
        }
    }

    public static class NoSuchWidgetTypeException
    extends Exception {
        public NoSuchWidgetTypeException() {
        }

        public NoSuchWidgetTypeException(String msg) {
            super(msg);
        }
    }

    public static enum Type {
        SEARCH_RESULT_COUNT,
        STREAM_SEARCH_RESULT_COUNT,
        FIELD_CHART,
        QUICKVALUES,
        SEARCH_RESULT_CHART,
        STATS_COUNT;

    }
}

