/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.database.EmbeddedPersistable;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.database.PersistedService;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.validators.ValidationResult;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.plugin.system.NodeId;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedServiceImpl
implements PersistedService {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedServiceImpl.class);
    public final MongoConnection mongoConnection;

    protected PersistedServiceImpl(MongoConnection mongoConnection) {
        this.mongoConnection = mongoConnection;
    }

    protected DBObject get(ObjectId id, String collectionName) {
        return this.collection(collectionName).findOne((DBObject)new BasicDBObject("_id", (Object)id));
    }

    protected <T extends Persisted> DBObject get(Class<T> modelClass, ObjectId id) {
        return this.collection((T)modelClass).findOne((DBObject)new BasicDBObject("_id", (Object)id));
    }

    protected <T extends Persisted> DBObject get(Class<T> modelClass, String id) {
        return this.get(modelClass, new ObjectId(id));
    }

    protected List<DBObject> query(DBObject query, String collectionName) {
        return this.query(query, this.collection(collectionName));
    }

    protected List<DBObject> query(DBObject query, DBCollection collection) {
        return this.cursorToList(collection.find(query));
    }

    protected <T extends Persisted> List<DBObject> query(Class<T> modelClass, DBObject query) {
        return this.query(query, this.collection((T)modelClass));
    }

    protected <T extends Persisted> List<DBObject> query(Class<T> modelClass, DBObject query, DBObject sort) {
        return this.cursorToList(this.collection((T)modelClass).find(query).sort(sort));
    }

    protected <T extends Persisted> List<DBObject> query(Class<T> modelClass, DBObject query, DBObject sort, int limit, int offset) {
        return this.cursorToList(this.collection((T)modelClass).find(query).sort(sort).limit(limit).skip(offset));
    }

    protected long count(DBObject query, String collectionName) {
        return this.collection(collectionName).count(query);
    }

    protected <T extends Persisted> long count(Class<T> modelClass, DBObject query) {
        return this.collection((T)modelClass).count(query);
    }

    private DBCollection collection(String collectionName) {
        return this.mongoConnection.getDatabase().getCollection(collectionName);
    }

    protected <T extends Persisted> DBCollection collection(Class<T> modelClass) {
        String collectionName;
        CollectionName collectionNameAnnotation = modelClass.getAnnotation(CollectionName.class);
        if (collectionNameAnnotation == null) {
            throw new RuntimeException("Unable to determine collection for class " + modelClass.getCanonicalName());
        }
        String string = collectionName = collectionNameAnnotation == null ? null : collectionNameAnnotation.value();
        if (collectionName == null) {
            return null;
        }
        return this.collection(collectionName);
    }

    protected <T extends Persisted> DBCollection collection(T model) {
        return this.collection((T)model.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DBObject> cursorToList(DBCursor cursor) {
        ArrayList results = Lists.newArrayList();
        if (cursor == null) {
            return results;
        }
        try {
            while (cursor.hasNext()) {
                results.add(cursor.next());
            }
        }
        finally {
            cursor.close();
        }
        return results;
    }

    protected <T extends Persisted> DBObject findOne(Class<T> model, DBObject query) {
        return this.collection((T)model).findOne(query);
    }

    protected <T extends Persisted> DBObject findOne(Class<T> model, DBObject query, DBObject sort) {
        return this.collection((T)model).findOne(query, (DBObject)new BasicDBObject(), sort);
    }

    protected DBObject findOne(DBObject query, String collectionName) {
        return this.collection(collectionName).findOne(query);
    }

    protected DBObject findOne(DBObject query, DBObject sort, String collectioName) {
        return this.collection(collectioName).findOne(query, (DBObject)new BasicDBObject(), sort);
    }

    protected long totalCount(String collectionName) {
        return this.collection(collectionName).count();
    }

    protected <T extends Persisted> long totalCount(Class<T> modelClass) {
        return this.collection((T)modelClass).count();
    }

    public <T extends Persisted> int destroy(T model) {
        return this.collection(model).remove((DBObject)new BasicDBObject("_id", (Object)new ObjectId(model.getId()))).getN();
    }

    public <T extends Persisted> int destroyAll(Class<T> modelClass) {
        return this.collection((T)modelClass).remove((DBObject)new BasicDBObject()).getN();
    }

    protected int destroyAll(String collectionName) {
        return this.collection(collectionName).remove((DBObject)new BasicDBObject()).getN();
    }

    protected int destroy(DBObject query, String collectionName) {
        return this.collection(collectionName).remove(query).getN();
    }

    protected <T extends Persisted> int destroyAll(Class<T> modelClass, DBObject query) {
        return this.collection((T)modelClass).remove(query).getN();
    }

    public <T extends Persisted> String save(T model) throws ValidationException {
        Map<String, List<ValidationResult>> errors = this.validate(model, (Map<String, Object>)model.getFields());
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
        BasicDBObject doc = new BasicDBObject(model.getFields());
        doc.put("_id", (Object)new ObjectId(model.getId()));
        this.fieldTransformations((Map<String, Object>)doc);
        BasicDBObject q = new BasicDBObject("_id", (Object)new ObjectId(model.getId()));
        this.collection(model).update((DBObject)q, (DBObject)doc, true, false);
        return model.getId();
    }

    public <T extends Persisted> String saveWithoutValidation(T model) {
        try {
            return this.save(model);
        }
        catch (ValidationException validationException) {
            return null;
        }
    }

    public <T extends Persisted> Map<String, List<ValidationResult>> validate(T model, Map<String, Object> fields) {
        return this.validate(model.getValidations(), fields);
    }

    public Map<String, List<ValidationResult>> validate(Map<String, Validator> validators, Map<String, Object> fields) {
        HashMap<String, List<ValidationResult>> validationErrors = new HashMap<String, List<ValidationResult>>();
        if (validators == null || validators.isEmpty()) {
            return validationErrors;
        }
        for (Map.Entry<String, Validator> validation : validators.entrySet()) {
            Validator v = validation.getValue();
            String field = validation.getKey();
            try {
                ValidationResult validationResult = v.validate(fields.get(field));
                if (!(validationResult instanceof ValidationResult.ValidationFailed)) continue;
                LOG.debug("Validation failure: [{}] on field [{}]", (Object)v.getClass().getCanonicalName(), (Object)field);
                if (validationErrors.get(field) == null) {
                    validationErrors.put(field, new ArrayList());
                }
                ((List)validationErrors.get(field)).add(validationResult);
            }
            catch (Exception e) {
                String error = "Error while trying to validate <" + field + ">, got exception: " + e;
                LOG.debug(error);
                if (validationErrors.get(field) == null) {
                    validationErrors.put(field, new ArrayList());
                }
                ((List)validationErrors.get(field)).add(new ValidationResult.ValidationFailed(error));
            }
        }
        return validationErrors;
    }

    public <T extends Persisted> Map<String, List<ValidationResult>> validate(T model) {
        return this.validate(model, (Map<String, Object>)model.getFields());
    }

    protected <T extends Persisted> void embed(T model, String key, EmbeddedPersistable o) throws ValidationException {
        Map<String, List<ValidationResult>> errors = this.validate(model.getEmbeddedValidations(key), (Map<String, Object>)o.getPersistedFields());
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
        HashMap fields = Maps.newHashMap((Map)o.getPersistedFields());
        this.fieldTransformations(fields);
        BasicDBObject dbo = new BasicDBObject((Map)fields);
        this.collection(model).update((DBObject)new BasicDBObject("_id", (Object)new ObjectId(model.getId())), (DBObject)new BasicDBObject("$push", (Object)new BasicDBObject(key, (Object)dbo)));
    }

    protected <T extends Persisted> void removeEmbedded(T model, String key, String searchId) {
        BasicDBObject aryQry = new BasicDBObject("id", (Object)searchId);
        BasicDBObject qry = new BasicDBObject("_id", (Object)new ObjectId(model.getId()));
        BasicDBObject update = new BasicDBObject("$pull", (Object)new BasicDBObject(key, (Object)aryQry));
        this.collection(model).update((DBObject)qry, (DBObject)update);
    }

    protected <T extends Persisted> void removeEmbedded(T model, String arrayKey, String key, String searchId) {
        BasicDBObject aryQry = new BasicDBObject(arrayKey, (Object)searchId);
        BasicDBObject qry = new BasicDBObject("_id", (Object)new ObjectId(model.getId()));
        BasicDBObject update = new BasicDBObject("$pull", (Object)new BasicDBObject(key, (Object)aryQry));
        this.collection(model).update((DBObject)qry, (DBObject)update);
    }

    private void fieldTransformations(Map<String, Object> doc) {
        for (Map.Entry<String, Object> x : doc.entrySet()) {
            if (x.getValue() instanceof Map) {
                x.setValue(Maps.newHashMap((Map)((Map)x.getValue())));
                this.fieldTransformations((Map)x.getValue());
                continue;
            }
            if (x.getValue() instanceof DateTime) {
                doc.put(x.getKey(), ((DateTime)x.getValue()).toDate());
            }
            if (!(x.getValue() instanceof NodeId)) continue;
            doc.put(x.getKey(), x.getValue().toString());
        }
    }
}

