/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bson.types.ObjectId;
import org.graylog2.grok.GrokPattern;
import org.graylog2.rest.models.system.responses.GrokPatternSummary;

public class GrokPatterns {
    public static GrokPatternSummary toSummary(GrokPattern grokPattern) {
        GrokPatternSummary summary = new GrokPatternSummary();
        summary.id = grokPattern.id.toHexString();
        summary.name = grokPattern.name;
        summary.pattern = grokPattern.pattern;
        return summary;
    }

    public static Set<GrokPatternSummary> toSummarySet(Set<GrokPattern> patternSet) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)patternSet.size());
        for (GrokPattern grokPattern : patternSet) {
            result.add(GrokPatterns.toSummary(grokPattern));
        }
        return result;
    }

    public static GrokPattern fromSummary(GrokPatternSummary grokPatternSummary) {
        GrokPattern result = new GrokPattern();
        if (!Strings.isNullOrEmpty((String)grokPatternSummary.id)) {
            result.id = new ObjectId(grokPatternSummary.id);
        }
        result.name = grokPatternSummary.name;
        result.pattern = grokPatternSummary.pattern;
        return result;
    }

    public static Set<GrokPattern> fromSummarySet(Collection<GrokPatternSummary> grokPatternSummaries) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)grokPatternSummaries.size());
        for (GrokPatternSummary summary : grokPatternSummaries) {
            result.add(GrokPatterns.fromSummary(summary));
        }
        return result;
    }
}

