/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches.timeranges;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;

public class RelativeRange
implements TimeRange {
    private final int range;

    public RelativeRange(int range) throws InvalidRangeParametersException {
        if (range < 0) {
            throw new InvalidRangeParametersException();
        }
        this.range = range;
    }

    @Override
    public TimeRange.Type getType() {
        return TimeRange.Type.RELATIVE;
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        return ImmutableMap.of((Object)"type", (Object)this.getType().toString().toLowerCase(), (Object)"range", (Object)this.getRange());
    }

    public int getRange() {
        return this.range;
    }

    @Override
    public DateTime getFrom() {
        if (this.getRange() > 0) {
            return Tools.iso8601().minus((ReadablePeriod)Seconds.seconds((int)this.getRange()));
        }
        return new DateTime(0L, DateTimeZone.UTC);
    }

    @Override
    public DateTime getTo() {
        return Tools.iso8601();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("range", this.range).add("from", (Object)this.getFrom()).add("to", (Object)this.getTo()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativeRange that = (RelativeRange)o;
        return this.range == that.range;
    }

    public int hashCode() {
        return this.range;
    }
}

