/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.alerts;

import com.codahale.metrics.annotation.Timed;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AlertService;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Alerts", description="Manage stream alerts")
@Path(value="/streams/{streamId}/alerts")
public class StreamAlertResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(StreamAlertResource.class);
    private static final String CACHE_KEY_BASE = "alerts";
    private static final Cache<String, Map<String, Object>> CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private final StreamService streamService;
    private final AlertService alertService;

    @Inject
    public StreamAlertResource(StreamService streamService, AlertService alertService) {
        this.streamService = streamService;
        this.alertService = alertService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get the 300 most recent alarms of this stream.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public Map<String, Object> list(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid, @ApiParam(name="since", value="Optional parameter to define a lower date boundary. (UNIX timestamp)", required=false) @QueryParam(value="since") int sinceTs) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        DateTime since = sinceTs > 0 ? new DateTime((long)sinceTs * 1000L, DateTimeZone.UTC) : null;
        Stream stream = this.streamService.load(streamid);
        ArrayList conditions = Lists.newArrayList();
        for (Alert alert : this.alertService.loadRecentOfStream(stream.getId(), since)) {
            conditions.add(alert.toMap());
        }
        return ImmutableMap.of((Object)CACHE_KEY_BASE, (Object)conditions, (Object)"total", (Object)this.alertService.totalCountForStream(streamid));
    }

    @GET
    @Timed
    @Path(value="check")
    @ApiOperation(value="Check for triggered alert conditions of this streams. Results cached for 30 seconds.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public Map<String, Object> checkConditions(@ApiParam(name="streamId", value="The ID of the stream to check.", required=true) @PathParam(value="streamId") String streamid) throws NotFoundException {
        Map result;
        this.checkPermission("streams:read", streamid);
        final Stream stream = this.streamService.load(streamid);
        try {
            result = (Map)CACHE.get((Object)(CACHE_KEY_BASE + stream.getId()), (Callable)new Callable<Map<String, Object>>(){

                @Override
                public Map<String, Object> call() throws Exception {
                    ArrayList results = Lists.newArrayList();
                    int triggered = 0;
                    for (AlertCondition alertCondition : StreamAlertResource.this.streamService.getAlertConditions(stream)) {
                        HashMap conditionResult = Maps.newHashMap();
                        conditionResult.put("condition", StreamAlertResource.this.alertService.asMap(alertCondition));
                        AlertCondition.CheckResult checkResult = StreamAlertResource.this.alertService.triggeredNoGrace(alertCondition);
                        conditionResult.put("triggered", checkResult.isTriggered());
                        if (checkResult.isTriggered()) {
                            ++triggered;
                            conditionResult.put("alert_description", checkResult.getResultDescription());
                        }
                        results.add(conditionResult);
                    }
                    return ImmutableMap.of((Object)"results", (Object)results, (Object)"calculated_at", (Object)Tools.getISO8601String((DateTime)Tools.iso8601()), (Object)"total_triggered", (Object)triggered);
                }
            });
        }
        catch (ExecutionException e) {
            LOG.error("Could not check for alerts.", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
        return result;
    }
}

