/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.inputs;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import com.eaio.uuid.UUID;
import com.google.common.collect.Lists;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.ConfigurationException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.inputs.converters.ConverterFactory;
import org.graylog2.inputs.extractors.ExtractorFactory;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.metrics.responses.TimerRateMetricsResponse;
import org.graylog2.rest.models.system.inputs.extractors.requests.CreateExtractorRequest;
import org.graylog2.rest.models.system.inputs.extractors.requests.OrderExtractorsRequest;
import org.graylog2.rest.models.system.inputs.extractors.responses.ExtractorCreated;
import org.graylog2.rest.models.system.inputs.extractors.responses.ExtractorMetrics;
import org.graylog2.rest.models.system.inputs.extractors.responses.ExtractorSummary;
import org.graylog2.rest.models.system.inputs.extractors.responses.ExtractorSummaryList;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.PersistedInputs;
import org.graylog2.shared.metrics.MetricUtils;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.rest.resources.system.inputs.InputsResource;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Extractors", description="Extractors of an input")
@Path(value="/system/inputs/{inputId}/extractors")
public class ExtractorsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractorsResource.class);
    private final InputService inputService;
    private final ActivityWriter activityWriter;
    private final InputRegistry inputs;
    private final MetricRegistry metricRegistry;
    private final ExtractorFactory extractorFactory;
    private final PersistedInputs persistedInputs;

    @Inject
    public ExtractorsResource(InputService inputService, ActivityWriter activityWriter, InputRegistry inputs, MetricRegistry metricRegistry, ExtractorFactory extractorFactory, PersistedInputs persistedInputs) {
        this.inputService = inputService;
        this.activityWriter = activityWriter;
        this.inputs = inputs;
        this.metricRegistry = metricRegistry;
        this.extractorFactory = extractorFactory;
        this.persistedInputs = persistedInputs;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add an extractor to an input", response=ExtractorCreated.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=400, message="No such extractor type."), @ApiResponse(code=400, message="Field the extractor should write on is reserved."), @ApiResponse(code=400, message="Missing or invalid configuration.")})
    public Response create(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateExtractorRequest cer) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        MessageInput input = this.inputs.getRunningInput(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException();
        }
        Input mongoInput = this.inputService.find(input.getPersistId());
        String id = new UUID().toString();
        Extractor extractor = this.buildExtractorFromRequest(cer, id);
        try {
            this.inputService.addExtractor(mongoInput, extractor);
        }
        catch (ValidationException e) {
            LOG.error("Extractor persist validation failed.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        String msg = "Added extractor <" + id + "> of type [" + cer.extractorType() + "] to input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, ExtractorsResource.class));
        ExtractorCreated result = ExtractorCreated.create((String)id);
        URI extractorUri = this.getUriBuilderToSelf().path(ExtractorsResource.class).path("{inputId}").build(new Object[]{input.getId()});
        return Response.created((URI)extractorUri).entity((Object)result).build();
    }

    @PUT
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an extractor")
    @Path(value="/{extractorId}")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=404, message="No such extractor on this input."), @ApiResponse(code=400, message="No such extractor type."), @ApiResponse(code=400, message="Field the extractor should write on is reserved."), @ApiResponse(code=400, message="Missing or invalid configuration.")})
    public ExtractorSummary update(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="extractorId", required=true) @PathParam(value="extractorId") String extractorId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateExtractorRequest cer) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        MessageInput input = this.persistedInputs.get(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException("Couldn't find input " + inputId);
        }
        Input mongoInput = this.inputService.find(input.getPersistId());
        Extractor originalExtractor = this.inputService.getExtractor(mongoInput, extractorId);
        Extractor extractor = this.buildExtractorFromRequest(cer, originalExtractor.getId());
        this.inputService.removeExtractor(mongoInput, originalExtractor.getId());
        try {
            this.inputService.addExtractor(mongoInput, extractor);
        }
        catch (ValidationException e) {
            LOG.error("Extractor persist validation failed.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        String msg = "Updated extractor <" + originalExtractor.getId() + "> of type [" + cer.extractorType() + "] in input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, ExtractorsResource.class));
        return this.toSummary(extractor);
    }

    @GET
    @Timed
    @ApiOperation(value="List all extractors of an input")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    @Produces(value={"application/json"})
    public ExtractorSummaryList list(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:read", inputId);
        Input input = this.inputService.find(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException();
        }
        ArrayList extractors = Lists.newArrayList();
        for (Extractor extractor : this.inputService.getExtractors(input)) {
            extractors.add(this.toSummary(extractor));
        }
        return ExtractorSummaryList.create((List)extractors);
    }

    @GET
    @Timed
    @ApiOperation(value="Get information of a single extractor of an input")
    @Path(value="/{extractorId}")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=404, message="No such extractor on this input.")})
    @Produces(value={"application/json"})
    public ExtractorSummary single(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="extractorId", required=true) @PathParam(value="extractorId") String extractorId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:read", inputId);
        MessageInput input = this.persistedInputs.get(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException("Couldn't find input " + inputId);
        }
        Input mongoInput = this.inputService.find(input.getPersistId());
        Extractor extractor = this.inputService.getExtractor(mongoInput, extractorId);
        return this.toSummary(extractor);
    }

    @DELETE
    @Timed
    @ApiOperation(value="Delete an extractor")
    @Path(value="/{extractorId}")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request."), @ApiResponse(code=404, message="Input not found."), @ApiResponse(code=404, message="Extractor not found.")})
    @Produces(value={"application/json"})
    public void terminate(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="extractorId", required=true) @PathParam(value="extractorId") String extractorId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        MessageInput input = this.persistedInputs.get(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException("Couldn't find input " + inputId);
        }
        Input mongoInput = this.inputService.find(input.getPersistId());
        Extractor extractor = this.inputService.getExtractor(mongoInput, extractorId);
        this.inputService.removeExtractor(mongoInput, extractor.getId());
        String msg = "Deleted extractor <" + extractorId + "> of type [" + extractor.getType() + "] " + "from input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, InputsResource.class));
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update extractor order of an input")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    @Path(value="order")
    public void order(@ApiParam(name="inputId", value="Persist ID (!) of input.", required=true) @PathParam(value="inputId") String inputPersistId, @ApiParam(name="JSON body", required=true) OrderExtractorsRequest oer) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputPersistId);
        Input mongoInput = this.inputService.find(inputPersistId);
        for (Extractor extractor : this.inputService.getExtractors(mongoInput)) {
            if (oer.order().containsValue(extractor.getId())) {
                extractor.setOrder((long)((Integer)Tools.getKeyByValue((Map)oer.order(), (Object)extractor.getId())).intValue());
            }
            this.inputService.removeExtractor(mongoInput, extractor.getId());
            try {
                this.inputService.addExtractor(mongoInput, extractor);
            }
            catch (ValidationException e) {
                LOG.warn("Validation error for extractor update.", (Throwable)e);
            }
        }
        LOG.info("Updated extractor ordering of input <persist:{}>.", (Object)inputPersistId);
    }

    private ExtractorSummary toSummary(Extractor extractor) {
        ExtractorMetrics metrics = ExtractorMetrics.create((TimerRateMetricsResponse)MetricUtils.buildTimerMap((Timer)((Timer)this.metricRegistry.getTimers().get(extractor.getTotalTimerName()))), (TimerRateMetricsResponse)MetricUtils.buildTimerMap((Timer)((Timer)this.metricRegistry.getTimers().get(extractor.getConverterTimerName()))));
        return ExtractorSummary.create((String)extractor.getId(), (String)extractor.getTitle(), (String)extractor.getType().toString().toLowerCase(), (String)extractor.getCursorStrategy().toString().toLowerCase(), (String)extractor.getSourceField(), (String)extractor.getTargetField(), (Map)extractor.getExtractorConfig(), (String)extractor.getCreatorUserId(), (List)extractor.converterConfigMap(), (String)extractor.getConditionType().toString().toLowerCase(), (String)extractor.getConditionValue(), (Long)extractor.getOrder(), (Long)extractor.getExceptionCount(), (Long)extractor.getConverterExceptionCount(), (ExtractorMetrics)metrics);
    }

    private List<Converter> loadConverters(Map<String, Map<String, Object>> requestConverters) {
        ArrayList converters = Lists.newArrayList();
        for (Map.Entry<String, Map<String, Object>> c : requestConverters.entrySet()) {
            try {
                converters.add(ConverterFactory.factory(Converter.Type.valueOf((String)c.getKey().toUpperCase()), c.getValue()));
            }
            catch (ConverterFactory.NoSuchConverterException e) {
                LOG.warn("No such converter [" + c.getKey() + "]. Skipping.", (Throwable)e);
            }
            catch (ConfigurationException e) {
                LOG.warn("Missing configuration for [" + c.getKey() + "]. Skipping.", (Throwable)e);
            }
        }
        return converters;
    }

    private Extractor buildExtractorFromRequest(CreateExtractorRequest cer, String id) {
        Extractor extractor;
        try {
            extractor = this.extractorFactory.factory(id, cer.title(), cer.order(), Extractor.CursorStrategy.valueOf((String)cer.cutOrCopy().toUpperCase()), Extractor.Type.valueOf((String)cer.extractorType().toUpperCase()), cer.sourceField(), cer.targetField(), cer.extractorConfig(), this.getCurrentUser().getName(), this.loadConverters(cer.converters()), Extractor.ConditionType.valueOf((String)cer.conditionType().toUpperCase()), cer.conditionValue());
        }
        catch (ExtractorFactory.NoSuchExtractorException e) {
            LOG.error("No such extractor type.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        catch (Extractor.ReservedFieldException e) {
            LOG.error("Cannot create extractor. Field is reserved.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        catch (ConfigurationException e) {
            LOG.error("Cannot create extractor. Missing configuration.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        return extractor;
    }
}

