/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.radio;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.bson.types.ObjectId;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.models.radio.requests.PingRequest;
import org.graylog2.rest.models.radio.responses.PersistedInputsResponse;
import org.graylog2.rest.models.radio.responses.PersistedInputsSummaryResponse;
import org.graylog2.rest.models.radio.responses.RegisterInputResponse;
import org.graylog2.rest.models.system.inputs.requests.RegisterInputRequest;
import org.graylog2.rest.models.system.radio.responses.RadioSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="System/Radios", description="Management of graylog2-radio nodes.")
@Path(value="/system/radios")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RadiosResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RadiosResource.class);
    private final NodeService nodeService;
    private final InputService inputService;

    @Inject
    public RadiosResource(NodeService nodeService, InputService inputService) {
        this.nodeService = nodeService;
        this.inputService = inputService;
    }

    @GET
    @Timed
    @ApiOperation(value="List all active radios in this cluster.")
    public Map<String, Object> radios() {
        ArrayList radioList = Lists.newArrayList();
        Map<String, Node> radios = this.nodeService.allActive(Node.Type.RADIO);
        for (Map.Entry<String, Node> radio : radios.entrySet()) {
            radioList.add(this.radioSummary(radio.getValue()));
        }
        return ImmutableMap.of((Object)"total", (Object)radios.size(), (Object)"radios", (Object)radioList);
    }

    @GET
    @Timed
    @ApiOperation(value="Information about a radio.", notes="This is returning information of a radio in context to its state in the cluster. Use the system API of the node itself to get system information.")
    @Path(value="/{radioId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Radio not found.")})
    public RadioSummary radio(@ApiParam(name="radioId", required=true) @PathParam(value="radioId") String radioId) {
        Node radio;
        try {
            radio = this.nodeService.byNodeId(radioId);
        }
        catch (NodeNotFoundException e) {
            LOG.error("Radio <{}> not found.", (Object)radioId);
            throw new NotFoundException((Throwable)e);
        }
        if (radio == null) {
            LOG.error("Radio <{}> not found.", (Object)radioId);
            throw new NotFoundException();
        }
        return this.radioSummary(radio);
    }

    @POST
    @Timed
    @ApiOperation(value="Register input of a radio.", notes="Radio inputs register their own inputs here for persistence after they successfully launched it.")
    @Path(value="/{radioId}/inputs")
    @ApiResponses(value={@ApiResponse(code=404, message="Radio not found."), @ApiResponse(code=400, message="Missing or invalid configuration")})
    public Response registerInput(@ApiParam(name="radioId", required=true) @PathParam(value="radioId") String radioId, @ApiParam(name="JSON body", required=true) @Valid @NotNull RegisterInputRequest rir) throws ValidationException {
        Node radio;
        try {
            radio = this.nodeService.byNodeId(radioId);
        }
        catch (NodeNotFoundException e) {
            LOG.error("Radio <{}> not found.", (Object)radioId);
            throw new NotFoundException((Throwable)e);
        }
        if (radio == null) {
            LOG.error("Radio <{}> not found.", (Object)radioId);
            throw new NotFoundException();
        }
        HashMap inputData = Maps.newHashMap();
        if (rir.inputId() != null) {
            inputData.put("input_id", rir.inputId());
        } else {
            inputData.put("input_id", new ObjectId().toHexString());
            inputData.put("title", rir.title());
            inputData.put("type", rir.type());
            inputData.put("creator_user_id", rir.creatorUserId());
            inputData.put("configuration", rir.configuration());
            inputData.put("created_at", Tools.iso8601());
            inputData.put("radio_id", rir.radioId());
        }
        Input mongoInput = this.inputService.create(inputData);
        String id = this.inputService.save(mongoInput);
        URI radioUri = this.getUriBuilderToSelf().path(RadiosResource.class).path("{radioId}").build(new Object[]{id});
        return Response.created((URI)radioUri).entity((Object)RegisterInputResponse.create((String)id)).build();
    }

    @DELETE
    @Timed
    @ApiOperation(value="Unregister input of a radio.", notes="Radios unregister their inputs when they are stopped/terminated on the radio.")
    @Path(value="/{radioId}/inputs/{inputId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Radio not found.")})
    public void unregisterInput(@ApiParam(name="radioId", required=true) @PathParam(value="radioId") String radioId, @ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws org.graylog2.database.NotFoundException {
        Node radio;
        try {
            radio = this.nodeService.byNodeId(radioId);
        }
        catch (NodeNotFoundException e) {
            LOG.error("Radio <{}> not found.", (Object)radioId);
            throw new NotFoundException("Radio <" + radioId + "> not found.");
        }
        if (radio == null) {
            LOG.error("Radio <{}> not found.", (Object)radioId);
            throw new NotFoundException("Radio <" + radioId + "> not found.");
        }
        Input input = this.inputService.findForThisRadioOrGlobal(radioId, inputId);
        if (!input.isGlobal().booleanValue()) {
            this.inputService.destroy(input);
        }
    }

    @GET
    @Timed
    @ApiOperation(value="Persisted inputs of a radio.", notes="This is returning the configured persisted inputs of a radio node. This is *not* returning the actually running inputs on a radio node. Radio nodes use this resource to get their configured inputs on startup.")
    @Path(value="/{radioId}/inputs")
    @ApiResponses(value={@ApiResponse(code=404, message="Radio not found.")})
    public PersistedInputsSummaryResponse persistedInputs(@ApiParam(name="radioId", required=true) @PathParam(value="radioId") String radioId) {
        Node radio = null;
        try {
            radio = this.nodeService.byNodeId(radioId);
        }
        catch (NodeNotFoundException e) {
            LOG.debug("Radio <{}> not found.", (Object)radioId);
        }
        ArrayList inputs = Lists.newArrayList();
        if (radio != null) {
            for (Input input : this.inputService.allOfRadio(radio)) {
                inputs.add(PersistedInputsResponse.create((String)input.getType(), (String)input.getId(), (String)input.getTitle(), (String)input.getCreatorUserId(), (String)Tools.getISO8601String((DateTime)input.getCreatedAt()), (Boolean)input.isGlobal(), input.getConfiguration()));
            }
        }
        return PersistedInputsSummaryResponse.create((List)inputs);
    }

    @PUT
    @Timed
    @ApiOperation(value="Ping - Accepts pings of graylog2-radio nodes.", notes="Every graylog2-radio node is regularly pinging to announce that it is active.")
    @Path(value="/{radioId}/ping")
    public void ping(@ApiParam(name="radioId", required=true) @PathParam(value="radioId") String radioId, @ApiParam(name="JSON body", required=true) @Valid @NotNull PingRequest pr) {
        LOG.debug("Ping from graylog2-radio node [{}].", (Object)radioId);
        Node node = null;
        try {
            node = this.nodeService.byNodeId(radioId);
        }
        catch (NodeNotFoundException e) {
            LOG.debug("There is no registered (or only outdated) graylog2-radio node [{}]. Registering.", (Object)radioId);
        }
        if (node != null) {
            this.nodeService.markAsAlive(node, false, pr.restTransportAddress());
            LOG.debug("Updated state of graylog2-radio node [{}].", (Object)radioId);
        } else {
            this.nodeService.registerRadio(radioId, pr.restTransportAddress());
        }
    }

    private RadioSummary radioSummary(Node node) {
        return RadioSummary.create((String)node.getNodeId(), (String)node.getType().toString().toLowerCase(), (String)node.getTransportAddress(), (String)Tools.getISO8601String((DateTime)node.getLastSeen()), (String)node.getShortNodeId());
    }
}

