/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.ldap;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.List;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.security.ldap.LdapSettingsImpl;
import org.graylog2.security.ldap.LdapSettingsService;
import org.graylog2.shared.security.ldap.LdapSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSettingsServiceImpl
extends PersistedServiceImpl
implements LdapSettingsService {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSettingsServiceImpl.class);
    private final LdapSettingsImpl.Factory ldapSettingsFactory;

    @Inject
    public LdapSettingsServiceImpl(MongoConnection mongoConnection, LdapSettingsImpl.Factory ldapSettingsFactory) {
        super(mongoConnection);
        this.ldapSettingsFactory = ldapSettingsFactory;
    }

    @Override
    public LdapSettings load() {
        BasicDBObject query = new BasicDBObject();
        List<DBObject> results = this.query(LdapSettingsImpl.class, (DBObject)query);
        if (results.size() == 0) {
            return null;
        }
        if (results.size() > 1) {
            LOG.error("Graylog does not yet support multiple LDAP backends, but {} configurations were found. This is a bug, ignoring LDAP config.", (Object)results.size());
            return null;
        }
        DBObject settingsObject = results.get(0);
        return this.ldapSettingsFactory.create((ObjectId)settingsObject.get("_id"), settingsObject.toMap());
    }

    @Override
    public void delete() {
        BasicDBObject query = new BasicDBObject();
        this.destroyAll(LdapSettingsImpl.class, (DBObject)query);
    }
}

