/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.outputs.OutputRegistry;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.rest.models.streams.outputs.requests.CreateOutputRequest;
import org.graylog2.streams.OutputImpl;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamService;

public class OutputServiceImpl
extends PersistedServiceImpl
implements OutputService {
    private final StreamService streamService;
    private final OutputRegistry outputRegistry;

    @Inject
    public OutputServiceImpl(MongoConnection mongoConnection, StreamService streamService, OutputRegistry outputRegistry) {
        super(mongoConnection);
        this.streamService = streamService;
        this.outputRegistry = outputRegistry;
    }

    @Override
    public Output load(String streamOutputId) throws NotFoundException {
        DBObject o = this.get(OutputImpl.class, streamOutputId);
        if (o == null) {
            throw new NotFoundException("Output <" + streamOutputId + "> not found!");
        }
        return new OutputImpl((ObjectId)o.get("_id"), o.toMap());
    }

    @Override
    public Set<Output> loadAll() {
        return this.loadAll(new HashMap<String, Object>());
    }

    protected Set<Output> loadAll(Map<String, Object> additionalQueryOpts) {
        HashSet<Output> outputs = new HashSet<Output>();
        BasicDBObject query = new BasicDBObject();
        for (Map.Entry<String, Object> o : additionalQueryOpts.entrySet()) {
            query.put(o.getKey(), o.getValue());
        }
        List<DBObject> results = this.query(OutputImpl.class, (DBObject)query);
        for (DBObject o : results) {
            outputs.add(new OutputImpl((ObjectId)o.get("_id"), o.toMap()));
        }
        return outputs;
    }

    @Override
    public Output create(Output request) throws ValidationException {
        OutputImpl impl = this.getImplOrFail(request);
        String id = this.save(impl);
        impl.setId(id);
        return request;
    }

    @Override
    public Output create(CreateOutputRequest request, String userId) throws ValidationException {
        return this.create(new OutputImpl(request.title(), request.type(), request.configuration(), Tools.iso8601().toDate(), userId, request.contentPack()));
    }

    @Override
    public void destroy(Output output) throws NotFoundException {
        OutputImpl impl = this.getImplOrFail(output);
        this.streamService.removeOutputFromAllStreams(output);
        this.outputRegistry.removeOutput(output);
        super.destroy(impl);
    }

    @Override
    public Output update(String id, Map<String, Object> deltas) {
        return null;
    }

    @Override
    public long count() {
        return this.totalCount(OutputImpl.class);
    }

    @Override
    public Map<String, Long> countByType() {
        DBCursor outputTypes = this.collection(OutputImpl.class).find(null, (DBObject)new BasicDBObject("type", (Object)1));
        HashMap<String, Long> outputsCountByType = new HashMap<String, Long>(outputTypes.count());
        for (DBObject outputType : outputTypes) {
            String type = (String)outputType.get("type");
            if (type == null) continue;
            Long oldValue = (Long)outputsCountByType.get(type);
            Long newValue = oldValue == null ? 1L : oldValue + 1L;
            outputsCountByType.put(type, newValue);
        }
        return outputsCountByType;
    }

    OutputImpl getImplOrFail(Output output) {
        if (output instanceof OutputImpl) {
            OutputImpl impl = (OutputImpl)output;
            return impl;
        }
        throw new IllegalArgumentException("Passed object must be of OutputImpl class, not " + output.getClass());
    }
}

