/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.stats;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.bundles.BundleService;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.inputs.InputService;
import org.graylog2.shared.users.UserService;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.graylog2.system.stats.ClusterStats;
import org.graylog2.system.stats.elasticsearch.ElasticsearchProbe;
import org.graylog2.system.stats.elasticsearch.ElasticsearchStats;
import org.graylog2.system.stats.mongo.MongoProbe;
import org.graylog2.system.stats.mongo.MongoStats;

@Singleton
public class ClusterStatsService {
    private final ElasticsearchProbe elasticsearchProbe;
    private final MongoProbe mongoProbe;
    private final UserService userService;
    private final InputService inputService;
    private final StreamService streamService;
    private final StreamRuleService streamRuleService;
    private final OutputService outputService;
    private final DashboardService dashboardService;
    private final BundleService bundleService;

    @Inject
    public ClusterStatsService(ElasticsearchProbe elasticsearchProbe, MongoProbe mongoProbe, UserService userService, InputService inputService, StreamService streamService, StreamRuleService streamRuleService, OutputService outputService, DashboardService dashboardService, BundleService bundleService) {
        this.elasticsearchProbe = elasticsearchProbe;
        this.mongoProbe = mongoProbe;
        this.userService = userService;
        this.inputService = inputService;
        this.streamService = streamService;
        this.streamRuleService = streamRuleService;
        this.outputService = outputService;
        this.dashboardService = dashboardService;
        this.bundleService = bundleService;
    }

    public ClusterStats clusterStats() {
        return ClusterStats.create(this.elasticsearchStats(), this.mongoStats(), this.streamService.count(), this.streamRuleService.totalStreamRuleCount(), this.streamRuleService.streamRuleCountByStream(), this.userService.count(), this.outputService.count(), this.outputService.countByType(), this.dashboardService.count(), this.inputService.totalCount(), this.inputService.globalCount(), this.inputService.totalCountByType(), this.inputService.totalExtractorCount(), this.inputService.totalExtractorCountByType(), this.bundleService.count());
    }

    public ElasticsearchStats elasticsearchStats() {
        return this.elasticsearchProbe.elasticsearchStats();
    }

    public MongoStats mongoStats() {
        return this.mongoProbe.mongoStats();
    }
}

