/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.github.joschi.jadconfig.JadConfig;
import com.github.joschi.jadconfig.ParameterException;
import com.github.joschi.jadconfig.RepositoryException;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.repositories.EnvironmentRepository;
import com.github.joschi.jadconfig.repositories.InMemoryRepository;
import com.github.joschi.jadconfig.repositories.PropertiesRepository;
import com.github.joschi.jadconfig.repositories.SystemPropertiesRepository;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.log4j.Level;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.elasticsearch.search.SearchHit;
import org.graylog2.Configuration;
import org.graylog2.bindings.providers.EsClientProvider;
import org.graylog2.bindings.providers.EsNodeProvider;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.plugin.Tools;
import org.graylog2.shared.bindings.GuiceInstantiationService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESTimestampFixup {
    private static final Logger LOG = LoggerFactory.getLogger(ESTimestampFixup.class);
    private static final String ENVIRONMENT_PREFIX = "GRAYLOG2_";
    private static final String PROPERTIES_PREFIX = "graylog2.";
    private final Node node;
    private final ElasticsearchConfiguration configuration;

    public static void main(String[] args) {
        CommandLineOptions commandLineOptions = new CommandLineOptions();
        JCommander jCommander = new JCommander((Object)commandLineOptions, args);
        jCommander.setProgramName("graylog2-es-fixup");
        if (commandLineOptions.isDebug()) {
            org.apache.log4j.Logger.getLogger(ESTimestampFixup.class).setLevel(Level.DEBUG);
        } else {
            org.apache.log4j.Logger.getLogger(ESTimestampFixup.class).setLevel(Level.INFO);
        }
        if (commandLineOptions.isHelp()) {
            jCommander.usage();
            System.exit(0);
        }
        if (commandLineOptions.getIndicesArray().length == 0) {
            System.out.println("No indices given. Use '-i graylog2_0 graylog2_1 graylog2_2' command line option.");
            jCommander.usage();
            System.exit(1);
        }
        JadConfig jadConfig = new JadConfig();
        Configuration configuration = ESTimestampFixup.readConfiguration(jadConfig, commandLineOptions);
        GuiceInstantiationService instantiationService = new GuiceInstantiationService();
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new Bindings(configuration)});
        instantiationService.setInjector(injector);
        ((ESTimestampFixup)injector.getInstance(ESTimestampFixup.class)).run(commandLineOptions, args);
    }

    @Inject
    public ESTimestampFixup(Node node, ElasticsearchConfiguration configuration, CommandLineOptions options) {
        this.node = node;
        this.configuration = configuration;
    }

    private void run(CommandLineOptions commandLineOptions, String[] args) {
        this.startEsNode();
        Client client = this.node.client();
        SearchRequestBuilder srb = client.prepareSearch(new String[0]);
        CountResponse countResponse = (CountResponse)client.prepareCount(commandLineOptions.getIndicesArray()).execute().actionGet();
        long totalCount = countResponse.getCount();
        long changedCount = 0L;
        long processedCount = 0L;
        srb.setIndices(commandLineOptions.getIndicesArray());
        srb.setSearchType(SearchType.SCAN);
        srb.setScroll(TimeValue.timeValueMinutes((long)commandLineOptions.getScrollTimeout()));
        srb.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        srb.setSize(commandLineOptions.getBatchSize());
        srb.addField("_id");
        srb.addField("timestamp");
        srb.addField("_source");
        SearchRequest request = srb.request();
        SearchResponse response = (SearchResponse)client.search(request).actionGet();
        if (!commandLineOptions.isFix()) {
            LOG.warn("Not executing update because '-F' command line flag not given!");
        }
        while (true) {
            SearchResponse r;
            if ((r = (SearchResponse)client.prepareSearchScroll(response.getScrollId()).setScroll(TimeValue.timeValueMinutes((long)1L)).execute().actionGet()).getHits().getHits().length == 0) break;
            BulkRequestBuilder bulk = client.prepareBulk();
            for (SearchHit hit : r.getHits()) {
                ++processedCount;
                try {
                    if (!this.handleHit(hit, bulk)) continue;
                    ++changedCount;
                }
                catch (Exception e) {
                    LOG.error("Error handling document " + hit.getId(), (Throwable)e);
                }
            }
            this.processBulk(bulk, commandLineOptions.isFix());
            LOG.info("Changed {} of total {} documents ({}% checked)", new Object[]{changedCount, totalCount, String.format("%.2f", (double)processedCount / (double)totalCount * 100.0)});
        }
        LOG.debug("No more hits, done!");
        this.stopEsNode();
    }

    private boolean handleHit(SearchHit hit, BulkRequestBuilder bulk) {
        if (hit.field("timestamp").value() instanceof Long) {
            LOG.debug("UPDATE {}/{}/{} (from {})", new Object[]{hit.getIndex(), hit.getType(), hit.getId(), hit.field("timestamp").value().getClass()});
            Map source = hit.getSource();
            long timestamp = (Long)hit.field("timestamp").getValue();
            source.put("timestamp", Tools.buildElasticSearchTimeFormat((DateTime)new DateTime(timestamp, DateTimeZone.UTC)));
            if (hit.field("_id") == null) {
                source.put("_id", hit.getId());
            }
            bulk.add(this.node.client().prepareIndex(hit.getIndex(), hit.getType(), hit.getId()).setSource(source));
            return true;
        }
        return false;
    }

    private void startEsNode() {
        LOG.debug("Starting ES node (port={})", (Object)this.configuration.getTransportTcpPort());
        this.node.start();
        this.node.client().admin().cluster().health(new ClusterHealthRequest(new String[0]).waitForYellowStatus()).actionGet(this.configuration.getClusterDiscoveryTimeout(), TimeUnit.MILLISECONDS);
    }

    private void stopEsNode() {
        LOG.debug("Stopping ES node");
        this.node.stop();
    }

    private void processBulk(BulkRequestBuilder bulk, boolean fix) {
        if (fix) {
            if (bulk.numberOfActions() > 0) {
                LOG.info("Executing {} bulk actions", (Object)bulk.numberOfActions());
                BulkResponse bulkResponse = (BulkResponse)bulk.execute().actionGet();
                if (bulkResponse.hasFailures()) {
                    LOG.error("BULK ERROR {}", (Object)bulkResponse.buildFailureMessage());
                } else {
                    LOG.info("Bulk action took {}ms", (Object)bulkResponse.getTookInMillis());
                }
            } else {
                LOG.debug("No bulk actions to execute!");
            }
        }
    }

    private static Configuration readConfiguration(JadConfig jadConfig, CommandLineOptions options) {
        Configuration configuration = new Configuration();
        ImmutableMap config = ImmutableMap.of((Object)"elasticsearch_transport_tcp_port", (Object)String.valueOf(options.getPort()));
        jadConfig.addConfigurationBean((Object)configuration);
        jadConfig.setRepositories(Arrays.asList(new InMemoryRepository((Map)config), new EnvironmentRepository(ENVIRONMENT_PREFIX), new SystemPropertiesRepository(PROPERTIES_PREFIX), new PropertiesRepository(options.getConfigFile())));
        LOG.debug("Loading configuration from config file: {}", (Object)options.getConfigFile());
        try {
            jadConfig.process();
        }
        catch (RepositoryException e) {
            LOG.error("Couldn't load configuration: {}", (Object)e.getMessage());
            System.exit(1);
        }
        catch (ParameterException | ValidationException e) {
            LOG.error("Invalid configuration", e);
            System.exit(1);
        }
        return configuration;
    }

    public static class Bindings
    extends AbstractModule {
        private final Configuration configuration;

        public Bindings(Configuration configuration) {
            this.configuration = configuration;
        }

        protected void configure() {
            this.bind(Configuration.class).toInstance((Object)this.configuration);
            this.bind(Node.class).toProvider(EsNodeProvider.class).in(Scopes.SINGLETON);
            this.bind(Client.class).toProvider(EsClientProvider.class).in(Scopes.SINGLETON);
        }
    }

    @Parameters(commandDescription="Graylog ES fixup tool")
    public static class CommandLineOptions {
        @Parameter(names={"-F", "--fix"}, description="Fix problems")
        private boolean fix = false;
        @Parameter(names={"-f", "--configfile"}, description="Configuration file for Graylog")
        private String configFile = "/etc/graylog/server/server.conf";
        @Parameter(names={"-i", "--indices"}, description="Indices to process (required)", variableArity=true)
        private List<String> indices = Lists.newArrayList();
        @Parameter(names={"-h", "--help"}, description="Show usage")
        private boolean help = false;
        @Parameter(names={"-p", "--port"}, description="ES TCP transport port")
        private int port = 9351;
        @Parameter(names={"-b", "--batch"}, description="ES scroll size (per shard)")
        private int batchSize = 500;
        @Parameter(names={"-t", "--timeout"}, description="ES scroll timeout in minutes")
        private int scrollTimeout = 1;
        @Parameter(names={"-d", "--debug"}, description="Enable debug output")
        private boolean debug = false;

        public boolean isFix() {
            return this.fix;
        }

        public String getConfigFile() {
            return this.configFile;
        }

        public boolean isHelp() {
            return this.help;
        }

        public String[] getIndicesArray() {
            return this.indices.toArray(new String[this.indices.size()]);
        }

        public int getPort() {
            return this.port;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public int getScrollTimeout() {
            return this.scrollTimeout;
        }

        public boolean isDebug() {
            return this.debug;
        }
    }
}

