/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alarmcallbacks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.alerts.AlertSender;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackConfigurationException;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAlarmCallback
implements AlarmCallback {
    private static final Logger LOG = LoggerFactory.getLogger(EmailAlarmCallback.class);
    private final AlertSender alertSender;
    private final NotificationService notificationService;
    private final NodeId nodeId;
    private Configuration configuration;

    @Inject
    public EmailAlarmCallback(AlertSender alertSender, NotificationService notificationService, NodeId nodeId) {
        this.alertSender = alertSender;
        this.notificationService = notificationService;
        this.nodeId = nodeId;
    }

    public void call(Stream stream, AlertCondition.CheckResult result) {
        AlertCondition alertCondition = result.getTriggeredCondition();
        if (stream.getAlertReceivers().size() > 0) {
            try {
                if (alertCondition.getBacklog() > 0 && result.getMatchingMessages() != null) {
                    this.alertSender.sendEmails(stream, result, this.getAlarmBacklog(result));
                } else {
                    this.alertSender.sendEmails(stream, result);
                }
            }
            catch (TransportConfigurationException e) {
                LOG.warn("Stream [{}] has alert receivers and is triggered, but email transport is not configured.", (Object)stream);
                Notification notification = this.notificationService.buildNow().addNode(this.nodeId.toString()).addType(Notification.Type.EMAIL_TRANSPORT_CONFIGURATION_INVALID).addSeverity(Notification.Severity.NORMAL).addDetail("stream_id", stream.getId()).addDetail("exception", e.getMessage());
                this.notificationService.publishIfFirst(notification);
            }
            catch (Exception e) {
                LOG.error("Stream [" + stream + "] has alert receivers and is triggered, but sending emails failed", (Throwable)e);
                String exceptionDetail = e.toString();
                if (e.getCause() != null) {
                    exceptionDetail = exceptionDetail + " (" + e.getCause() + ")";
                }
                Notification notification = this.notificationService.buildNow().addNode(this.nodeId.toString()).addType(Notification.Type.EMAIL_TRANSPORT_FAILED).addSeverity(Notification.Severity.NORMAL).addDetail("stream_id", stream.getId()).addDetail("exception", exceptionDetail);
                this.notificationService.publishIfFirst(notification);
            }
        }
    }

    protected List<Message> getAlarmBacklog(AlertCondition.CheckResult result) {
        AlertCondition alertCondition = result.getTriggeredCondition();
        List matchingMessages = result.getMatchingMessages();
        int effectiveBacklogSize = Math.min(alertCondition.getBacklog(), matchingMessages.size());
        if (effectiveBacklogSize == 0) {
            return Collections.emptyList();
        }
        List backlogSummaries = matchingMessages.subList(0, effectiveBacklogSize);
        ArrayList backlog = Lists.newArrayListWithCapacity((int)effectiveBacklogSize);
        for (MessageSummary messageSummary : backlogSummaries) {
            backlog.add(messageSummary.getRawMessage());
        }
        return backlog;
    }

    public void initialize(Configuration config) throws AlarmCallbackConfigurationException {
        this.configuration = config;
        this.alertSender.initialize(this.configuration);
    }

    public ConfigurationRequest getRequestedConfiguration() {
        ConfigurationRequest configurationRequest = new ConfigurationRequest();
        configurationRequest.addField((ConfigurationField)new TextField("sender", "Sender", "graylog@example.org", "The sender of sent out mail alerts", ConfigurationField.Optional.NOT_OPTIONAL));
        configurationRequest.addField((ConfigurationField)new TextField("subject", "E-Mail Subject", "Graylog alert for stream: ${stream.title}: ${check_result.resultDescription}", "The subject of sent out mail alerts", ConfigurationField.Optional.NOT_OPTIONAL));
        configurationRequest.addField((ConfigurationField)new TextField("body", "E-Mail Body", "##########\nAlert Description: ${check_result.resultDescription}\nDate: ${check_result.triggeredAt}\nStream ID: ${stream.id}\nStream title: ${stream.title}\nStream description: ${stream.description}\n${if stream_url}Stream URL: ${stream_url}${end}\n\nTriggered condition: ${check_result.triggeredCondition}\n##########\n\n${if backlog}Last messages accounting for this alert:\n${foreach backlog message}${message}\n${end}${else}<No backlog>\n${end}\n", "The template to generate the body from", ConfigurationField.Optional.OPTIONAL, new TextField.Attribute[]{TextField.Attribute.TEXTAREA}));
        return configurationRequest;
    }

    public String getName() {
        return "Email Alert Callback";
    }

    public Map<String, Object> getAttributes() {
        return this.configuration.getSource();
    }

    public void checkConfiguration() throws ConfigurationException {
        if (this.configuration.getString("sender") == null || this.configuration.getString("sender").isEmpty() || this.configuration.getString("subject") == null || this.configuration.getString("subject").isEmpty()) {
            throw new ConfigurationException("Sender or subject are missing or invalid!");
        }
    }
}

