/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings;

import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.elasticsearch.client.Client;
import org.elasticsearch.node.Node;
import org.graylog2.Configuration;
import org.graylog2.alerts.AlertSender;
import org.graylog2.alerts.FormattedEmailAlertSender;
import org.graylog2.alerts.types.FieldContentValueAlertCondition;
import org.graylog2.alerts.types.FieldValueAlertCondition;
import org.graylog2.alerts.types.MessageCountAlertCondition;
import org.graylog2.bindings.providers.BundleExporterProvider;
import org.graylog2.bindings.providers.BundleImporterProvider;
import org.graylog2.bindings.providers.ClusterEventBusProvider;
import org.graylog2.bindings.providers.DefaultSecurityManagerProvider;
import org.graylog2.bindings.providers.EsClientProvider;
import org.graylog2.bindings.providers.EsNodeProvider;
import org.graylog2.bindings.providers.LdapConnectorProvider;
import org.graylog2.bindings.providers.LdapUserAuthenticatorProvider;
import org.graylog2.bindings.providers.MongoConnectionProvider;
import org.graylog2.bindings.providers.RotationStrategyProvider;
import org.graylog2.bindings.providers.RulesEngineProvider;
import org.graylog2.bindings.providers.SystemJobFactoryProvider;
import org.graylog2.bindings.providers.SystemJobManagerProvider;
import org.graylog2.buffers.processors.ServerProcessBufferProcessor;
import org.graylog2.bundles.BundleService;
import org.graylog2.cluster.ClusterConfigServiceImpl;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.database.MongoConnection;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.filters.FilterService;
import org.graylog2.filters.FilterServiceImpl;
import org.graylog2.indexer.SetIndexReadOnlyJob;
import org.graylog2.indexer.healing.FixDeflectorByDeleteJob;
import org.graylog2.indexer.healing.FixDeflectorByMoveJob;
import org.graylog2.indexer.indices.jobs.OptimizeIndexJob;
import org.graylog2.indexer.ranges.CreateNewSingleIndexRangeJob;
import org.graylog2.indexer.ranges.RebuildIndexRangesJob;
import org.graylog2.inputs.InputStateListener;
import org.graylog2.inputs.PersistedInputsImpl;
import org.graylog2.jersey.container.netty.SecurityContextFactory;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.RulesEngine;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.rest.NotFoundExceptionMapper;
import org.graylog2.rest.RestAccessLogFilter;
import org.graylog2.rest.ScrollChunkWriter;
import org.graylog2.rest.ValidationExceptionMapper;
import org.graylog2.security.ShiroSecurityContextFactory;
import org.graylog2.security.ldap.LdapConnector;
import org.graylog2.security.ldap.LdapSettingsImpl;
import org.graylog2.security.realm.LdapUserAuthenticator;
import org.graylog2.shared.buffers.processors.ProcessBufferProcessor;
import org.graylog2.shared.inputs.PersistedInputs;
import org.graylog2.shared.journal.JournalReaderModule;
import org.graylog2.shared.journal.KafkaJournalModule;
import org.graylog2.shared.journal.NoopJournalModule;
import org.graylog2.shared.metrics.jersey2.MetricsDynamicBinding;
import org.graylog2.shared.security.RestrictToMasterFeature;
import org.graylog2.shared.security.ShiroSecurityBinding;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.streams.StreamRouter;
import org.graylog2.streams.StreamRouterEngine;
import org.graylog2.system.activities.SystemMessageActivityWriter;
import org.graylog2.system.debug.ClusterDebugEventListener;
import org.graylog2.system.debug.LocalDebugEventListener;
import org.graylog2.system.jobs.SystemJobFactory;
import org.graylog2.system.jobs.SystemJobManager;
import org.graylog2.system.shutdown.GracefulShutdown;
import org.graylog2.system.stats.ClusterStatsModule;

public class ServerBindings
extends AbstractModule {
    private final Configuration configuration;
    private final Set<ServerStatus.Capability> capabilities;

    public ServerBindings(Configuration configuration, Set<ServerStatus.Capability> capabilities) {
        this.configuration = configuration;
        this.capabilities = capabilities;
    }

    protected void configure() {
        this.bindInterfaces();
        this.bindSingletons();
        this.bindProviders();
        this.bindFactoryModules();
        this.bindDynamicFeatures();
        this.bindContainerResponseFilters();
        this.bindExceptionMappers();
        this.bindAdditionalJerseyComponents();
        this.bindPluginMetaData();
        this.bindEventBusListeners();
    }

    private void bindProviders() {
        this.bind(RotationStrategy.class).toProvider(RotationStrategyProvider.class);
        this.bind(EventBus.class).annotatedWith(ClusterEventBus.class).toProvider(ClusterEventBusProvider.class).asEagerSingleton();
    }

    private void bindFactoryModules() {
        this.install(new FactoryModuleBuilder().build(RebuildIndexRangesJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(OptimizeIndexJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(SetIndexReadOnlyJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(CreateNewSingleIndexRangeJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(FixDeflectorByDeleteJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(FixDeflectorByMoveJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(LdapSettingsImpl.Factory.class));
        this.install(new FactoryModuleBuilder().build(FieldValueAlertCondition.Factory.class));
        this.install(new FactoryModuleBuilder().build(MessageCountAlertCondition.Factory.class));
        this.install(new FactoryModuleBuilder().build(FieldContentValueAlertCondition.Factory.class));
        this.install(new FactoryModuleBuilder().build(WidgetCacheTime.Factory.class));
    }

    private void bindSingletons() {
        this.bind(Configuration.class).toInstance((Object)this.configuration);
        this.bind(BaseConfiguration.class).toInstance((Object)this.configuration);
        this.bind(MongoConnection.class).toProvider(MongoConnectionProvider.class);
        Multibinder capabilityBinder = Multibinder.newSetBinder((Binder)this.binder(), ServerStatus.Capability.class);
        for (ServerStatus.Capability capability : this.capabilities) {
            capabilityBinder.addBinding().toInstance((Object)capability);
        }
        this.bind(ServerStatus.class).in(Scopes.SINGLETON);
        if (this.configuration.isMessageJournalEnabled()) {
            this.install((Module)new KafkaJournalModule());
            this.install((Module)new JournalReaderModule());
        } else {
            this.install((Module)new NoopJournalModule());
        }
        this.bind(Node.class).toProvider(EsNodeProvider.class).asEagerSingleton();
        this.bind(Client.class).toProvider(EsClientProvider.class).asEagerSingleton();
        this.bind(SystemJobManager.class).toProvider(SystemJobManagerProvider.class);
        this.bind(RulesEngine.class).toProvider(RulesEngineProvider.class);
        this.bind(LdapConnector.class).toProvider(LdapConnectorProvider.class);
        this.bind(LdapUserAuthenticator.class).toProvider(LdapUserAuthenticatorProvider.class);
        this.bind(DefaultSecurityManager.class).toProvider(DefaultSecurityManagerProvider.class).asEagerSingleton();
        this.bind(SystemJobFactory.class).toProvider(SystemJobFactoryProvider.class);
        this.bind(GracefulShutdown.class).in(Scopes.SINGLETON);
        this.bind(BundleService.class).in(Scopes.SINGLETON);
        this.bind(BundleImporterProvider.class).in(Scopes.SINGLETON);
        this.bind(BundleExporterProvider.class).in(Scopes.SINGLETON);
        this.bind(ClusterStatsModule.class).asEagerSingleton();
        this.bind(ClusterConfigService.class).to(ClusterConfigServiceImpl.class).asEagerSingleton();
        this.bind(String[].class).annotatedWith((Annotation)Names.named((String)"RestControllerPackages")).toInstance((Object)new String[]{"org.graylog2.rest.resources", "org.graylog2.shared.rest.resources"});
    }

    private void bindInterfaces() {
        this.bind(SecurityContextFactory.class).to(ShiroSecurityContextFactory.class);
        this.bind(AlertSender.class).to(FormattedEmailAlertSender.class);
        this.bind(StreamRouter.class);
        this.install(new FactoryModuleBuilder().implement(StreamRouterEngine.class, StreamRouterEngine.class).build(StreamRouterEngine.Factory.class));
        this.bind(FilterService.class).to(FilterServiceImpl.class).in(Scopes.SINGLETON);
        this.bind(ActivityWriter.class).to(SystemMessageActivityWriter.class);
        this.bind(PersistedInputs.class).to(PersistedInputsImpl.class);
        this.bind(ProcessBufferProcessor.class).to(ServerProcessBufferProcessor.class);
    }

    private void bindDynamicFeatures() {
        TypeLiteral<Class<? extends DynamicFeature>> type = new TypeLiteral<Class<? extends DynamicFeature>>(){};
        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)type);
        setBinder.addBinding().toInstance(ShiroSecurityBinding.class);
        setBinder.addBinding().toInstance(MetricsDynamicBinding.class);
        setBinder.addBinding().toInstance(RestrictToMasterFeature.class);
    }

    private void bindContainerResponseFilters() {
        TypeLiteral<Class<? extends ContainerResponseFilter>> type = new TypeLiteral<Class<? extends ContainerResponseFilter>>(){};
        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)type);
        setBinder.addBinding().toInstance(RestAccessLogFilter.class);
    }

    private void bindExceptionMappers() {
        TypeLiteral<Class<? extends ExceptionMapper>> type = new TypeLiteral<Class<? extends ExceptionMapper>>(){};
        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)type);
        setBinder.addBinding().toInstance(NotFoundExceptionMapper.class);
        setBinder.addBinding().toInstance(ValidationExceptionMapper.class);
    }

    private void bindAdditionalJerseyComponents() {
        Multibinder componentBinder = Multibinder.newSetBinder((Binder)this.binder(), Class.class, (Annotation)Names.named((String)"additionalJerseyComponents"));
        componentBinder.addBinding().toInstance(ScrollChunkWriter.class);
    }

    private void bindPluginMetaData() {
        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), PluginMetaData.class);
    }

    private void bindEventBusListeners() {
        this.bind(InputStateListener.class).asEagerSingleton();
        this.bind(LocalDebugEventListener.class).asEagerSingleton();
        this.bind(ClusterDebugEventListener.class).asEagerSingleton();
    }
}

