/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.graylog2.Configuration;
import org.graylog2.plugin.RulesEngine;
import org.graylog2.rules.DroolsEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RulesEngineProvider
implements Provider<RulesEngine> {
    private static final Logger LOG = LoggerFactory.getLogger(RulesEngineProvider.class);
    private static RulesEngine rulesEngine = null;

    @Inject
    public RulesEngineProvider(Configuration configuration, DroolsEngine droolsEngine) {
        rulesEngine = droolsEngine;
        String rulesFilePath = configuration.getDroolsRulesFile();
        if (rulesFilePath != null && !rulesFilePath.isEmpty()) {
            if (rulesEngine.addRulesFromFile(rulesFilePath)) {
                LOG.info("Using rules: {}", (Object)rulesFilePath);
            } else {
                LOG.info("Unable to load rules due to load error: {}", (Object)rulesFilePath);
            }
        } else {
            LOG.info("No static rules file loaded.");
        }
    }

    public RulesEngine get() {
        return rulesEngine;
    }
}

