/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;

public class ComputationResult {
    private final Object result;
    private final long tookMs;
    private final DateTime calculatedAt;
    private final AbsoluteRange computationTimeRange;

    public ComputationResult(Object result, long tookMs) {
        this(result, tookMs, null);
    }

    public ComputationResult(Object result, long tookMs, AbsoluteRange computationTimeRange) {
        this.result = result;
        this.tookMs = tookMs;
        this.computationTimeRange = computationTimeRange;
        this.calculatedAt = Tools.iso8601();
    }

    public Object getResult() {
        return this.result;
    }

    public DateTime getCalculatedAt() {
        return this.calculatedAt;
    }

    public long getTookMs() {
        return this.tookMs;
    }

    public Map<String, Object> asMap() {
        HashMap map = Maps.newHashMap();
        map.put("result", this.result);
        map.put("calculated_at", Tools.getISO8601String((DateTime)this.calculatedAt));
        map.put("took_ms", this.tookMs);
        if (this.computationTimeRange != null) {
            HashMap timeRangeMap = Maps.newHashMap();
            timeRangeMap.put("from", Tools.getISO8601String((DateTime)this.computationTimeRange.getFrom()));
            timeRangeMap.put("to", Tools.getISO8601String((DateTime)this.computationTimeRange.getTo()));
            map.put("computation_time_range", timeRangeMap);
        }
        return map;
    }
}

