/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.indexer.results.CountResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;

public class SearchResultCountWidget
extends DashboardWidget {
    protected final Searches searches;
    protected final String query;
    protected final TimeRange timeRange;
    protected final Boolean trend;
    protected final Boolean lowerIsBetter;

    public SearchResultCountWidget(MetricRegistry metricRegistry, Searches searches, String id, String description, WidgetCacheTime cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) {
        this(metricRegistry, DashboardWidget.Type.SEARCH_RESULT_COUNT, searches, id, description, cacheTime, config, query, timeRange, creatorUserId);
    }

    protected SearchResultCountWidget(MetricRegistry metricRegistry, DashboardWidget.Type type, Searches searches, String id, String description, WidgetCacheTime cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) {
        super(metricRegistry, type, id, description, cacheTime, config, creatorUserId);
        this.searches = searches;
        this.query = query;
        this.timeRange = timeRange;
        this.trend = config.get("trend") != null && Boolean.parseBoolean(String.valueOf(config.get("trend")));
        this.lowerIsBetter = config.get("lower_is_better") != null && Boolean.parseBoolean(String.valueOf(config.get("lower_is_better")));
    }

    protected Searches getSearches() {
        return this.searches;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        return ImmutableMap.builder().put((Object)"query", (Object)this.query).put((Object)"timerange", this.timeRange.getPersistedConfig()).put((Object)"trend", (Object)this.trend).put((Object)"lower_is_better", (Object)this.lowerIsBetter).build();
    }

    @Override
    protected ComputationResult compute() {
        return this.computeInternal(null);
    }

    protected ComputationResult computeInternal(String filter) {
        CountResult cr = this.searches.count(this.query, this.timeRange, filter);
        if (this.trend.booleanValue() && this.timeRange instanceof RelativeRange) {
            DateTime toPrevious = this.timeRange.getFrom();
            DateTime fromPrevious = toPrevious.minus((ReadablePeriod)Seconds.seconds((int)((RelativeRange)this.timeRange).getRange()));
            AbsoluteRange previousTimeRange = new AbsoluteRange(fromPrevious, toPrevious);
            CountResult previousCr = this.searches.count(this.query, previousTimeRange);
            HashMap results = Maps.newHashMap();
            results.put("now", cr.getCount());
            results.put("previous", previousCr.getCount());
            long tookMs = cr.getTookMs() + previousCr.getTookMs();
            return new ComputationResult(results, tookMs);
        }
        return new ComputationResult(cr.getCount(), cr.getTookMs());
    }
}

