/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.google.common.base.Preconditions;
import com.mongodb.CommandFailureException;
import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.configuration.MongoDbConfiguration;
import org.graylog2.database.MongoConnection;

@Singleton
public class MongoConnectionImpl
implements MongoConnection {
    private final MongoClientURI mongoClientURI;
    private MongoClient m = null;
    private DB db = null;

    @Inject
    public MongoConnectionImpl(MongoDbConfiguration configuration) {
        this(configuration.getMongoClientURI());
    }

    MongoConnectionImpl(MongoClientURI mongoClientURI) {
        this.mongoClientURI = (MongoClientURI)Preconditions.checkNotNull((Object)mongoClientURI);
    }

    @Override
    public synchronized Mongo connect() {
        if (this.m == null) {
            try {
                this.m = new MongoClient(this.mongoClientURI);
                this.db = this.m.getDB(this.mongoClientURI.getDatabase());
                this.db.setWriteConcern(WriteConcern.SAFE);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Cannot resolve host name for MongoDB", e);
            }
        }
        try {
            this.db.command("{ ping: 1 }");
        }
        catch (CommandFailureException e) {
            if (e.getCode() == 18) {
                throw new MongoException("Couldn't connect to MongoDB. Please check the authentication credentials.", (Throwable)e);
            }
            throw new MongoException("Couldn't connect to MongoDB: " + e.getMessage(), (Throwable)e);
        }
        return this.m;
    }

    @Override
    public DB getDatabase() {
        return this.db;
    }
}

