/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.indexer.IndexFailure;
import org.graylog2.indexer.IndexFailureImpl;
import org.graylog2.indexer.IndexFailureService;
import org.joda.time.DateTime;

public class IndexFailureServiceImpl
extends PersistedServiceImpl
implements IndexFailureService {
    @Inject
    public IndexFailureServiceImpl(MongoConnection mongoConnection) {
        super(mongoConnection);
        String collectionName = IndexFailureImpl.class.getAnnotation(CollectionName.class).value();
        if (!mongoConnection.getDatabase().collectionExists(collectionName)) {
            DBObject options = BasicDBObjectBuilder.start().add("capped", (Object)true).add("size", (Object)0x3200000).get();
            mongoConnection.getDatabase().createCollection(collectionName, options);
        }
    }

    @Override
    public List<IndexFailure> all(int limit, int offset) {
        ArrayList failures = Lists.newArrayList();
        BasicDBObject sort = new BasicDBObject();
        sort.put("$natural", (Object)-1);
        List<DBObject> results = this.query(IndexFailureImpl.class, (DBObject)new BasicDBObject(), (DBObject)sort, limit, offset);
        for (DBObject o : results) {
            failures.add(new IndexFailureImpl((ObjectId)o.get("_id"), o.toMap()));
        }
        return failures;
    }

    @Override
    public long countSince(DateTime since) {
        BasicDBObject query = new BasicDBObject();
        query.put("timestamp", (Object)new BasicDBObject("$gte", (Object)since.toDate()));
        return this.count(IndexFailureImpl.class, (DBObject)query);
    }

    @Override
    public long totalCount() {
        return this.collection(IndexFailureImpl.class).count();
    }
}

