/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.extractors;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.graylog2.ConfigurationException;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;

public class SplitAndIndexExtractor
extends Extractor {
    public final String splitChar;
    public final int index;

    public SplitAndIndexExtractor(MetricRegistry metricRegistry, String id, String title, long order, Extractor.CursorStrategy cursorStrategy, String sourceField, String targetField, Map<String, Object> extractorConfig, String creatorUserId, List<Converter> converters, Extractor.ConditionType conditionType, String conditionValue) throws Extractor.ReservedFieldException, ConfigurationException {
        super(metricRegistry, id, title, order, Extractor.Type.SPLIT_AND_INDEX, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
        if (extractorConfig == null || extractorConfig.get("index") == null || extractorConfig.get("split_by") == null) {
            throw new ConfigurationException("Missing configuration fields. Required: index, split_by");
        }
        try {
            this.index = (Integer)extractorConfig.get("index") - 1;
            this.splitChar = (String)extractorConfig.get("split_by");
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Parameters cannot be casted.");
        }
    }

    protected Extractor.Result[] run(String value) {
        String result = SplitAndIndexExtractor.cut(value, this.splitChar, this.index);
        if (result == null) {
            return null;
        }
        int[] range = SplitAndIndexExtractor.getCutIndices(value, this.splitChar, this.index);
        return new Extractor.Result[]{new Extractor.Result(result, range[0], range[1])};
    }

    public static String cut(String s, String splitChar, int index) {
        if (s == null || splitChar == null || index < 0) {
            return null;
        }
        String[] parts = s.split(Pattern.quote(splitChar));
        if (parts.length <= index) {
            return null;
        }
        return Strings.emptyToNull((String)parts[index]);
    }

    public static int[] getCutIndices(String s, String splitChar, int index) {
        int found = 0;
        char target = splitChar.charAt(0);
        for (int i = 0; i < s.length(); ++i) {
            int end;
            if (s.charAt(i) == target) {
                ++found;
            }
            if (found != index) continue;
            int begin = i;
            if (begin != 0) {
                ++begin;
            }
            if ((end = s.indexOf(target, i + 1)) == -1) {
                end = s.length();
            }
            return new int[]{begin, end};
        }
        return new int[]{0, 0};
    }
}

