/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.database.NotFoundException;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.outputs.DefaultMessageOutput;
import org.graylog2.outputs.MessageOutputFactory;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.outputs.MessageOutputConfigurationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.streams.OutputService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OutputRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(OutputRegistry.class);
    private final Cache<String, MessageOutput> runningMessageOutputs;
    private final MessageOutput defaultMessageOutput;
    private final OutputService outputService;
    private final NotificationService notificationService;
    private final NodeId nodeId;
    private final MessageOutputFactory messageOutputFactory;
    private final LoadingCache<String, AtomicInteger> faultCounters;
    private final long faultCountThreshold;
    private final long faultPenaltySeconds;

    @Inject
    public OutputRegistry(@DefaultMessageOutput MessageOutput defaultMessageOutput, OutputService outputService, MessageOutputFactory messageOutputFactory, NotificationService notificationService, NodeId nodeId, @Named(value="output_fault_count_threshold") long faultCountThreshold, @Named(value="output_fault_penalty_seconds") long faultPenaltySeconds) {
        this.defaultMessageOutput = defaultMessageOutput;
        this.outputService = outputService;
        this.notificationService = notificationService;
        this.nodeId = nodeId;
        this.messageOutputFactory = messageOutputFactory;
        this.runningMessageOutputs = CacheBuilder.newBuilder().build();
        this.faultCountThreshold = faultCountThreshold;
        this.faultPenaltySeconds = faultPenaltySeconds;
        this.faultCounters = CacheBuilder.newBuilder().expireAfterWrite(this.faultPenaltySeconds, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String key) throws Exception {
                return new AtomicInteger(0);
            }
        });
    }

    public MessageOutput getOutputForIdAndStream(String id, Stream stream) {
        block5: {
            AtomicInteger faultCount;
            try {
                faultCount = (AtomicInteger)this.faultCounters.get((Object)id);
            }
            catch (ExecutionException e) {
                LOG.error("Unable to retrieve output fault counter: ", (Throwable)e);
                return null;
            }
            try {
                if ((long)faultCount.get() < this.faultCountThreshold) {
                    return (MessageOutput)this.runningMessageOutputs.get((Object)id, this.loadForIdAndStream(id, stream));
                }
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                if (e.getCause() instanceof NotFoundException) break block5;
                int number = faultCount.addAndGet(1);
                LOG.error("Unable to fetch output {}, fault #{}: ", new Object[]{id, number, e});
                if ((long)number < this.faultCountThreshold) break block5;
                LOG.error("Output {} has crossed threshold of {} faults in {} seconds. Disabling for {} seconds.", new Object[]{id, this.faultCountThreshold, this.faultPenaltySeconds, this.faultPenaltySeconds});
                Notification notification = this.notificationService.buildNow().addType(Notification.Type.OUTPUT_DISABLED).addSeverity(Notification.Severity.NORMAL).addNode(this.nodeId.toString()).addDetail("outputId", id).addDetail("streamId", stream.getId()).addDetail("streamTitle", stream.getTitle()).addDetail("faultCount", number).addDetail("faultCountThreshold", this.faultCountThreshold).addDetail("faultPenaltySeconds", this.faultPenaltySeconds);
                this.notificationService.publishIfFirst(notification);
            }
        }
        return null;
    }

    public Callable<MessageOutput> loadForIdAndStream(final String id, final Stream stream) {
        return new Callable<MessageOutput>(){

            @Override
            public MessageOutput call() throws Exception {
                Output output = OutputRegistry.this.outputService.load(id);
                return OutputRegistry.this.launchOutput(output, stream);
            }
        };
    }

    protected MessageOutput launchOutput(Output output, Stream stream) throws MessageOutputConfigurationException {
        MessageOutput messageOutput = this.messageOutputFactory.fromStreamOutput(output, stream, new Configuration(output.getConfiguration()));
        if (messageOutput == null) {
            throw new IllegalArgumentException("Failed to instantiate MessageOutput from Output: " + output);
        }
        return messageOutput;
    }

    protected Map<String, MessageOutput> getRunningMessageOutputs() {
        return ImmutableMap.copyOf((Map)this.runningMessageOutputs.asMap());
    }

    public Set<MessageOutput> getMessageOutputs() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.runningMessageOutputs.asMap().values());
        builder.add((Object)this.defaultMessageOutput);
        return ImmutableSet.copyOf((Collection)builder.build());
    }

    public void removeOutput(Output output) {
        MessageOutput messageOutput = (MessageOutput)this.runningMessageOutputs.getIfPresent((Object)output.getId());
        if (messageOutput != null) {
            messageOutput.stop();
        }
        this.runningMessageOutputs.invalidate((Object)output.getId());
        this.faultCounters.invalidate((Object)output.getId());
    }
}

