/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.initializers.IndexerSetupService;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRotationThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRotationThread.class);
    private NotificationService notificationService;
    private final Deflector deflector;
    private final ActivityWriter activityWriter;
    private final IndexerSetupService indexerSetupService;
    private final Indices indices;
    private final Provider<RotationStrategy> rotationStrategyProvider;

    @Inject
    public IndexRotationThread(NotificationService notificationService, Indices indices, Deflector deflector, ActivityWriter activityWriter, IndexerSetupService indexerSetupService, Provider<RotationStrategy> rotationStrategyProvider) {
        this.notificationService = notificationService;
        this.deflector = deflector;
        this.activityWriter = activityWriter;
        this.indexerSetupService = indexerSetupService;
        this.indices = indices;
        this.rotationStrategyProvider = rotationStrategyProvider;
    }

    public void doRun() {
        try {
            if (this.indexerSetupService.isRunning()) {
                this.checkAndRepair();
                this.checkForRotation();
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't point deflector to a new index", (Throwable)e);
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected void checkForRotation() {
        String currentTarget;
        RotationStrategy rotationStrategy = (RotationStrategy)this.rotationStrategyProvider.get();
        try {
            currentTarget = this.deflector.getNewestTargetName();
        }
        catch (NoTargetIndexException e) {
            LOG.error("Could not find current deflector target. Aborting.", (Throwable)e);
            return;
        }
        RotationStrategy.Result rotate = rotationStrategy.shouldRotate(currentTarget);
        if (rotate == null) {
            LOG.error("Cannot perform rotation at this moment.");
            return;
        }
        LOG.debug("Rotation strategy result: {}", (Object)rotate.getDescription());
        if (rotate.shouldRotate()) {
            LOG.info("Deflector index <{}> should be rotated, Pointing deflector to new index now!", (Object)currentTarget);
            this.deflector.cycle();
        } else {
            LOG.debug("Deflector index <{}> should not be rotated. Not doing anything.", (Object)currentTarget);
        }
    }

    protected void checkAndRepair() {
        if (!this.deflector.isUp()) {
            if (this.indices.exists(this.deflector.getName())) {
                Notification notification = this.notificationService.buildNow().addType(Notification.Type.DEFLECTOR_EXISTS_AS_INDEX).addSeverity(Notification.Severity.URGENT);
                boolean published = this.notificationService.publishIfFirst(notification);
                if (published) {
                    LOG.warn("There is an index called [" + this.deflector.getName() + "]. Cannot fix this automatically and published a notification.");
                }
            } else {
                this.deflector.setUp();
            }
        } else {
            try {
                String currentTarget = this.deflector.getCurrentActualTargetIndex();
                String shouldBeTarget = this.deflector.getNewestTargetName();
                if (!currentTarget.equals(shouldBeTarget)) {
                    String msg = "Deflector is pointing to [" + currentTarget + "], not the newest one: [" + shouldBeTarget + "]. Re-pointing.";
                    LOG.warn(msg);
                    this.activityWriter.write(new Activity(msg, IndexRotationThread.class));
                    this.deflector.pointTo(shouldBeTarget, currentTarget);
                }
            }
            catch (NoTargetIndexException e) {
                LOG.warn("Deflector is not up. Not trying to point to another index.");
            }
        }
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 10;
    }
}

