/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;
import org.graylog2.shared.rest.AdditionalMediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"text/csv"})
public class SearchResponseCsvWriter
implements MessageBodyWriter<SearchResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResponseCsvWriter.class);

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return SearchResponse.class.equals(type) && AdditionalMediaType.TEXT_CSV_TYPE.isCompatible(mediaType);
    }

    public long getSize(SearchResponse searchResponse, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(SearchResponse searchResponse, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        CSVWriter csvWriter = new CSVWriter((Writer)new OutputStreamWriter(entityStream, StandardCharsets.UTF_8));
        ImmutableSortedSet sortedFields = ImmutableSortedSet.copyOf((Iterable)Iterables.concat(searchResponse.fields(), (Iterable)Lists.newArrayList((Object[])new String[]{"source", "timestamp"})));
        csvWriter.writeNext((String[])sortedFields.toArray((Object[])new String[sortedFields.size()]));
        String[] fieldValues = new String[sortedFields.size()];
        for (ResultMessageSummary message : searchResponse.messages()) {
            int idx = 0;
            for (String fieldName : sortedFields) {
                Object val = message.message().get(fieldName);
                fieldValues[idx++] = val == null ? null : val.toString().replaceAll("\n", "\\\\n");
                fieldValues[idx++] = val == null ? null : val.toString().replaceAll("\r", "\\\\r");
            }
            csvWriter.writeNext(fieldValues);
        }
        if (csvWriter.checkError()) {
            LOG.error("Encountered unspecified error when writing message result as CSV, result is likely malformed.");
        }
        csvWriter.close();
    }
}

