/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.messages;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.elasticsearch.indices.IndexMissingException;
import org.graylog2.indexer.messages.DocumentNotFoundException;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.plugin.Message;
import org.graylog2.rest.models.messages.responses.MessageTokens;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Messages", description="Single messages")
@Path(value="/messages/{index}")
public class MessageResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(MessageResource.class);
    private Messages messages;

    @Inject
    public MessageResource(Messages messages) {
        this.messages = messages;
    }

    @GET
    @Path(value="/{messageId}")
    @Timed
    @ApiOperation(value="Get a single message.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Specified index does not exist."), @ApiResponse(code=404, message="Message does not exist.")})
    public ResultMessage search(@ApiParam(name="index", value="The index this message is stored in.", required=true) @PathParam(value="index") String index, @ApiParam(name="messageId", required=true) @PathParam(value="messageId") String messageId) {
        this.checkPermission("messages:read", messageId);
        try {
            ResultMessage resultMessage = this.messages.get(messageId, index);
            Message message = new Message(resultMessage.getMessage());
            this.checkMessageReadPermission(message);
            return resultMessage;
        }
        catch (IndexMissingException e) {
            String msg = "Index " + e.index().name() + " does not exist.";
            LOG.error(msg, (Throwable)e);
            throw new NotFoundException(msg, (Throwable)e);
        }
        catch (DocumentNotFoundException e) {
            String msg = "Message " + messageId + " does not exist in index " + index;
            LOG.error(msg, (Throwable)e);
            throw new NotFoundException(msg, (Throwable)e);
        }
    }

    private void checkMessageReadPermission(Message message) {
        if (this.isPermitted("streams:read", "*")) {
            return;
        }
        boolean permitted = false;
        for (String streamId : message.getStreamIds()) {
            if (!this.isPermitted("streams:read", streamId)) continue;
            permitted = true;
            break;
        }
        if (!permitted) {
            throw new ForbiddenException("Not authorized to access message " + message.getId());
        }
    }

    @GET
    @Path(value="/analyze")
    @Timed
    @ApiOperation(value="Analyze a message string", notes="Returns what tokens/terms a message string (message or full_message) is split to.")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"messages:analyze"})
    @ApiResponses(value={@ApiResponse(code=404, message="Specified index does not exist.")})
    public MessageTokens analyze(@ApiParam(name="index", value="The index the message containing the string is stored in.", required=true) @PathParam(value="index") String index, @ApiParam(name="string", value="The string to analyze.", required=true) @QueryParam(value="string") @NotEmpty String string) {
        try {
            return MessageTokens.create(this.messages.analyze(string, index));
        }
        catch (IndexMissingException e) {
            LOG.error("Index does not exist. Returning HTTP 404.");
            throw new NotFoundException("Index " + index + "does not exist.");
        }
    }
}

