/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.system.cluster.responses.NodeSummary;
import org.graylog2.rest.models.system.cluster.responses.NodeSummaryList;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="System/Cluster", description="Node discovery")
@Path(value="/system/cluster")
@Produces(value={"application/json"})
public class ClusterResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterResource.class);
    private final NodeService nodeService;
    private final NodeId nodeId;

    @Inject
    public ClusterResource(NodeService nodeService, NodeId nodeId) {
        this.nodeService = nodeService;
        this.nodeId = nodeId;
    }

    @GET
    @Timed
    @Path(value="/nodes")
    @ApiOperation(value="List all active nodes in this cluster.")
    public NodeSummaryList nodes() {
        ArrayList nodeList = Lists.newArrayList();
        Map<String, Node> nodes = this.nodeService.allActive(Node.Type.SERVER);
        for (Map.Entry<String, Node> e : nodes.entrySet()) {
            nodeList.add(this.nodeSummary(e.getValue()));
        }
        return NodeSummaryList.create((List)nodeList);
    }

    @GET
    @Timed
    @Path(value="/node")
    @ApiOperation(value="Information about this node.", notes="This is returning information of this node in context to its state in the cluster. Use the system API of the node itself to get system information.")
    public NodeSummary node() throws NodeNotFoundException {
        return this.nodeSummary(this.nodeService.byNodeId(this.nodeId));
    }

    @GET
    @Timed
    @Path(value="/nodes/{nodeId}")
    @ApiOperation(value="Information about a node.", notes="This is returning information of a node in context to its state in the cluster. Use the system API of the node itself to get system information.")
    @ApiResponses(value={@ApiResponse(code=404, message="Node not found.")})
    public NodeSummary node(@ApiParam(name="nodeId", required=true) @PathParam(value="nodeId") String nodeId) throws NodeNotFoundException {
        if (nodeId == null || nodeId.isEmpty()) {
            LOG.error("Missing nodeId. Returning HTTP 400.");
            throw new BadRequestException();
        }
        return this.nodeSummary(this.nodeService.byNodeId(nodeId));
    }

    private NodeSummary nodeSummary(Node node) {
        return NodeSummary.create((String)node.getNodeId(), (String)node.getType().toString().toLowerCase(), (boolean)node.isMaster(), (String)node.getTransportAddress(), (String)Tools.getISO8601String((DateTime)node.getLastSeen()), (String)node.getShortNodeId());
    }
}

