/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.plugin.Tools;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.activities.SystemMessage;
import org.graylog2.system.activities.SystemMessageService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Messages", description="Internal Graylog messages")
@Path(value="/system/messages")
public class MessagesResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(MessagesResource.class);
    private final SystemMessageService systemMessageService;

    @Inject
    public MessagesResource(SystemMessageService systemMessageService) {
        this.systemMessageService = systemMessageService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get internal Graylog system messages")
    @RequiresPermissions(value={"systemmessages:read"})
    @Produces(value={"application/json"})
    public Map<String, Object> all(@ApiParam(name="page", value="Page", required=false) @QueryParam(value="page") int page) {
        ArrayList messages = Lists.newArrayList();
        for (SystemMessage sm : this.systemMessageService.all(this.page(page))) {
            HashMap message = Maps.newHashMapWithExpectedSize((int)4);
            message.put("caller", sm.getCaller());
            message.put("content", sm.getContent());
            message.put("timestamp", Tools.getISO8601String((DateTime)sm.getTimestamp()));
            message.put("node_id", sm.getNodeId());
            messages.add(message);
        }
        return ImmutableMap.of((Object)"messages", (Object)messages, (Object)"total", (Object)this.systemMessageService.totalCount());
    }

    private int page(int page) {
        return Math.max(0, page - 1);
    }
}

