/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.rest.models.system.indexer.responses.ClusterHealth;
import org.graylog2.rest.models.system.indexer.responses.ClusterName;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Indexer/Cluster", description="Indexer cluster information")
@Path(value="/system/indexer/cluster")
public class IndexerClusterResource
extends RestResource {
    @Inject
    private Cluster cluster;

    @GET
    @Timed
    @Path(value="/name")
    @RequiresPermissions(value={"indexercluster:read"})
    @ApiOperation(value="Get the cluster name")
    @Produces(value={"application/json"})
    public ClusterName clusterName() {
        return ClusterName.create((String)this.cluster.health().getClusterName());
    }

    @GET
    @Timed
    @Path(value="/health")
    @ApiOperation(value="Get cluster and shard health overview")
    @RequiresPermissions(value={"indexercluster:read"})
    @Produces(value={"application/json"})
    public ClusterHealth clusterHealth() {
        ClusterHealthResponse health = this.cluster.health();
        ClusterHealth.ShardStatus shards = ClusterHealth.ShardStatus.create((int)health.getActiveShards(), (int)health.getInitializingShards(), (int)health.getRelocatingShards(), (int)health.getUnassignedShards());
        return ClusterHealth.create((String)health.getStatus().toString().toLowerCase(), (ClusterHealth.ShardStatus)shards);
    }
}

