/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import javax.inject.Inject;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.graylog2.jersey.container.netty.SecurityContextFactory;
import org.graylog2.security.AccessTokenAuthToken;
import org.graylog2.security.SessionIdToken;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroSecurityContextFactory
implements SecurityContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroSecurityContextFactory.class);
    private final DefaultSecurityManager sm;

    @Inject
    public ShiroSecurityContextFactory(DefaultSecurityManager sm) {
        this.sm = sm;
    }

    public SecurityContext create(String userName, String credential, boolean isSecure, String authcScheme, String host) {
        Object authToken = credential == null ? new UsernamePasswordToken(userName, credential, host) : (credential.equalsIgnoreCase("session") ? new SessionIdToken(userName, host) : (credential.equalsIgnoreCase("token") ? new AccessTokenAuthToken(userName, host) : new UsernamePasswordToken(userName, credential, host)));
        return new ShiroSecurityContext(new Subject.Builder((SecurityManager)this.sm).host(host).sessionCreationEnabled(false).buildSubject(), (AuthenticationToken)authToken, isSecure, authcScheme);
    }
}

