/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;

public class StreamListFingerprint {
    private final String fingerprint;

    public StreamListFingerprint(List<Stream> streams) {
        this.fingerprint = this.buildFingerprint(streams);
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    private String buildFingerprint(List<Stream> streams) {
        MessageDigest sha1Digest = DigestUtils.getSha1Digest();
        StringBuilder sb = new StringBuilder();
        for (Stream stream : Ordering.from(this.getStreamComparator()).sortedCopy(streams)) {
            sb.append(stream.hashCode());
            for (StreamRule rule : Ordering.from(this.getStreamRuleComparator()).sortedCopy((Iterable)stream.getStreamRules())) {
                sb.append(rule.hashCode());
            }
            for (Output output : Ordering.from(this.getOutputComparator()).sortedCopy((Iterable)stream.getOutputs())) {
                sb.append(output.hashCode());
            }
        }
        return String.valueOf(Hex.encodeHex((byte[])sha1Digest.digest(sb.toString().getBytes())));
    }

    private Comparator<Output> getOutputComparator() {
        return new Comparator<Output>(){

            @Override
            public int compare(Output output1, Output stream2) {
                return StreamListFingerprint.this.comparisonResult(output1.getId(), stream2.getId());
            }
        };
    }

    private Comparator<Stream> getStreamComparator() {
        return new Comparator<Stream>(){

            @Override
            public int compare(Stream stream1, Stream stream2) {
                return StreamListFingerprint.this.comparisonResult(stream1.getId(), stream2.getId());
            }
        };
    }

    private Comparator<StreamRule> getStreamRuleComparator() {
        return new Comparator<StreamRule>(){

            @Override
            public int compare(StreamRule rule1, StreamRule rule2) {
                return StreamListFingerprint.this.comparisonResult(rule1.getId(), rule2.getId());
            }
        };
    }

    private int comparisonResult(String id1, String id2) {
        return ComparisonChain.start().compare((Object)id1, (Object)id2, String.CASE_INSENSITIVE_ORDER).compare((Comparable)((Object)id1), (Comparable)((Object)id2)).result();
    }
}

