/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.database.EmbeddedPersistable;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;

public abstract class AbstractAlertCondition
implements EmbeddedPersistable,
AlertCondition {
    protected final String id;
    protected final Stream stream;
    protected final Type type;
    protected final DateTime createdAt;
    protected final String creatorUserId;
    protected final int grace;
    private final Map<String, Object> parameters;

    protected AbstractAlertCondition(Stream stream, String id, Type type, DateTime createdAt, String creatorUserId, Map<String, Object> parameters) {
        this.id = id == null ? UUID.randomUUID().toString() : id;
        this.stream = stream;
        this.type = type;
        this.createdAt = createdAt;
        this.creatorUserId = creatorUserId;
        this.parameters = parameters;
        this.grace = this.parameters.containsKey("grace") ? (Integer)this.parameters.get("grace") : 0;
    }

    protected abstract AlertCondition.CheckResult runCheck();

    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeString() {
        return this.type.toString();
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    @JsonIgnore
    public Stream getStream() {
        return this.stream;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Integer getBacklog() {
        Object rawParameter = this.getParameters().get("backlog");
        if (rawParameter != null && rawParameter instanceof Number) {
            return (Integer)rawParameter;
        }
        return 0;
    }

    public String toString() {
        return this.id + ":" + (Object)((Object)this.type) + "={" + this.getDescription() + "}" + ", stream:={" + this.stream + "}";
    }

    @JsonIgnore
    public Map<String, Object> getPersistedFields() {
        return ImmutableMap.builder().put((Object)"id", (Object)this.id).put((Object)"type", (Object)this.type.toString().toLowerCase()).put((Object)"creator_user_id", (Object)this.creatorUserId).put((Object)"created_at", (Object)Tools.getISO8601String((DateTime)this.createdAt)).put((Object)"parameters", this.parameters).build();
    }

    public int getGrace() {
        return this.grace;
    }

    public static class NegativeCheckResult
    extends CheckResult {
        public NegativeCheckResult(AlertCondition alertCondition) {
            super(false, alertCondition, null, null, null);
        }
    }

    public static class CheckResult
    implements AlertCondition.CheckResult {
        private final boolean isTriggered;
        private final String resultDescription;
        private final AlertCondition triggeredCondition;
        private final DateTime triggeredAt;
        private final ArrayList<MessageSummary> summaries = Lists.newArrayList();

        public CheckResult(boolean isTriggered, AlertCondition triggeredCondition, String resultDescription, DateTime triggeredAt, List<MessageSummary> summaries) {
            this.isTriggered = isTriggered;
            this.resultDescription = resultDescription;
            this.triggeredCondition = triggeredCondition;
            this.triggeredAt = triggeredAt;
            if (summaries != null) {
                this.summaries.addAll(summaries);
            }
        }

        public boolean isTriggered() {
            return this.isTriggered;
        }

        public String getResultDescription() {
            return this.resultDescription;
        }

        public AlertCondition getTriggeredCondition() {
            return this.triggeredCondition;
        }

        public DateTime getTriggeredAt() {
            return this.triggeredAt;
        }

        public List<MessageSummary> getMatchingMessages() {
            return this.summaries;
        }
    }

    public static class NoSuchAlertConditionTypeException
    extends Exception {
        public NoSuchAlertConditionTypeException(String msg) {
            super(msg);
        }
    }

    public static enum Type {
        MESSAGE_COUNT,
        FIELD_VALUE,
        FIELD_CONTENT_VALUE,
        DUMMY;

    }
}

