/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AlertImpl;
import org.graylog2.alerts.AlertService;
import org.graylog2.alerts.types.FieldContentValueAlertCondition;
import org.graylog2.alerts.types.FieldValueAlertCondition;
import org.graylog2.alerts.types.MessageCountAlertCondition;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.streams.alerts.requests.CreateConditionRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertServiceImpl
extends PersistedServiceImpl
implements AlertService {
    private static final Logger LOG = LoggerFactory.getLogger(AlertServiceImpl.class);
    private final FieldValueAlertCondition.Factory fieldValueAlertFactory;
    private final MessageCountAlertCondition.Factory messageCountAlertFactory;
    private final FieldContentValueAlertCondition.Factory fieldContentValueAlertFactory;

    @Inject
    public AlertServiceImpl(MongoConnection mongoConnection, FieldValueAlertCondition.Factory fieldValueAlertFactory, MessageCountAlertCondition.Factory messageCountAlertFactory, FieldContentValueAlertCondition.Factory fieldContentValueAlertFactory) {
        super(mongoConnection);
        this.fieldValueAlertFactory = fieldValueAlertFactory;
        this.messageCountAlertFactory = messageCountAlertFactory;
        this.fieldContentValueAlertFactory = fieldContentValueAlertFactory;
    }

    @Override
    public Alert factory(AlertCondition.CheckResult checkResult) {
        if (!checkResult.isTriggered()) {
            throw new RuntimeException("Tried to create alert from not triggered alert condition result.");
        }
        HashMap fields = Maps.newHashMap();
        fields.put("triggered_at", checkResult.getTriggeredAt());
        fields.put("condition_id", checkResult.getTriggeredCondition().getId());
        fields.put("stream_id", checkResult.getTriggeredCondition().getStream().getId());
        fields.put("description", checkResult.getResultDescription());
        fields.put("condition_parameters", checkResult.getTriggeredCondition().getParameters());
        return new AlertImpl(fields);
    }

    @Override
    public List<Alert> loadRecentOfStream(String streamId, DateTime since) {
        QueryBuilder qb = QueryBuilder.start((String)"stream_id").is((Object)streamId);
        if (since != null) {
            qb.and("triggered_at").greaterThanEquals((Object)since.toDate());
        }
        BasicDBObject sort = new BasicDBObject("triggered_at", (Object)-1);
        List<DBObject> alertObjects = this.query(AlertImpl.class, qb.get(), (DBObject)sort, 300, 0);
        ArrayList alerts = Lists.newArrayList();
        for (DBObject alertObj : alertObjects) {
            alerts.add(new AlertImpl(new ObjectId(alertObj.get("_id").toString()), alertObj.toMap()));
        }
        return alerts;
    }

    @Override
    public int triggeredSecondsAgo(String streamId, String conditionId) {
        BasicDBObject sort;
        DBObject query = QueryBuilder.start((String)"stream_id").is((Object)streamId).and("condition_id").is((Object)conditionId).get();
        DBObject alert = this.findOne(AlertImpl.class, query, (DBObject)(sort = new BasicDBObject("triggered_at", (Object)-1)));
        if (alert == null) {
            return -1;
        }
        DateTime triggeredAt = new DateTime(alert.get("triggered_at"), DateTimeZone.UTC);
        return Seconds.secondsBetween((ReadableInstant)triggeredAt, (ReadableInstant)Tools.iso8601()).getSeconds();
    }

    @Override
    public long totalCount() {
        return this.collection(AlertImpl.class).count();
    }

    @Override
    public long totalCountForStream(String streamId) {
        BasicDBObject qry = new BasicDBObject("stream_id", (Object)streamId);
        return this.collection(AlertImpl.class).count((DBObject)qry);
    }

    @Override
    public AlertCondition fromPersisted(Map<String, Object> fields, Stream stream) throws AbstractAlertCondition.NoSuchAlertConditionTypeException {
        AbstractAlertCondition.Type type;
        try {
            type = AbstractAlertCondition.Type.valueOf(((String)fields.get("type")).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new AbstractAlertCondition.NoSuchAlertConditionTypeException("No such alert condition type: [" + fields.get("type") + "]");
        }
        return this.createAlertCondition(type, stream, (String)fields.get("id"), DateTime.parse((String)((String)fields.get("created_at"))), (String)fields.get("creator_user_id"), (Map)fields.get("parameters"));
    }

    private AbstractAlertCondition createAlertCondition(AbstractAlertCondition.Type type, Stream stream, String id, DateTime createdAt, String creatorId, Map<String, Object> parameters) throws AbstractAlertCondition.NoSuchAlertConditionTypeException {
        switch (type) {
            case MESSAGE_COUNT: {
                return this.messageCountAlertFactory.createAlertCondition(stream, id, createdAt, creatorId, parameters);
            }
            case FIELD_VALUE: {
                return this.fieldValueAlertFactory.createAlertCondition(stream, id, createdAt, creatorId, parameters);
            }
            case FIELD_CONTENT_VALUE: {
                return this.fieldContentValueAlertFactory.createAlertCondition(stream, id, createdAt, creatorId, parameters);
            }
        }
        throw new AbstractAlertCondition.NoSuchAlertConditionTypeException("Unhandled alert condition type: " + (Object)((Object)type));
    }

    @Override
    public AbstractAlertCondition fromRequest(CreateConditionRequest ccr, Stream stream, String userId) throws AbstractAlertCondition.NoSuchAlertConditionTypeException {
        AbstractAlertCondition.Type type;
        try {
            type = AbstractAlertCondition.Type.valueOf(ccr.type().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new AbstractAlertCondition.NoSuchAlertConditionTypeException("No such alert condition type: [" + ccr.type() + "]");
        }
        Map parameters = ccr.parameters();
        return this.createAlertCondition(type, stream, null, Tools.iso8601(), userId, parameters);
    }

    @Override
    public AbstractAlertCondition updateFromRequest(AlertCondition alertCondition, CreateConditionRequest ccr) throws AbstractAlertCondition.NoSuchAlertConditionTypeException {
        AbstractAlertCondition.Type type = ((AbstractAlertCondition)alertCondition).getType();
        Map parameters = ccr.parameters();
        for (Map.Entry stringObjectEntry : alertCondition.getParameters().entrySet()) {
            if (parameters.containsKey(stringObjectEntry.getKey())) continue;
            parameters.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
        return this.createAlertCondition(type, alertCondition.getStream(), alertCondition.getId(), alertCondition.getCreatedAt(), alertCondition.getCreatorUserId(), parameters);
    }

    @Override
    public boolean inGracePeriod(AlertCondition alertCondition) {
        int lastAlertSecondsAgo = this.triggeredSecondsAgo(alertCondition.getStream().getId(), alertCondition.getId());
        if (lastAlertSecondsAgo == -1 || alertCondition.getGrace() == 0) {
            return false;
        }
        return lastAlertSecondsAgo < alertCondition.getGrace() * 60;
    }

    @Override
    public AlertCondition.CheckResult triggeredNoGrace(AlertCondition alertCondition) {
        LOG.debug("Checking alert condition [{}] and not accounting grace time.", (Object)this);
        return ((AbstractAlertCondition)alertCondition).runCheck();
    }

    @Override
    public AlertCondition.CheckResult triggered(AlertCondition alertCondition) {
        LOG.debug("Checking alert condition [{}]", (Object)this);
        if (this.inGracePeriod(alertCondition)) {
            LOG.debug("Alert condition [{}] is in grace period. Not triggered.", (Object)this);
            return new AbstractAlertCondition.NegativeCheckResult(alertCondition);
        }
        return ((AbstractAlertCondition)alertCondition).runCheck();
    }

    @Override
    public Map<String, Object> asMap(AlertCondition alertCondition) {
        return ImmutableMap.builder().put((Object)"id", (Object)alertCondition.getId()).put((Object)"type", (Object)alertCondition.getTypeString().toLowerCase()).put((Object)"creator_user_id", (Object)alertCondition.getCreatorUserId()).put((Object)"created_at", (Object)Tools.getISO8601String((DateTime)alertCondition.getCreatedAt())).put((Object)"parameters", (Object)alertCondition.getParameters()).put((Object)"in_grace", (Object)this.inGracePeriod(alertCondition)).build();
    }
}

