/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.elasticsearch.common.settings.loader.YamlSettingsLoader;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsNodeProvider
implements Provider<Node> {
    private static final Logger LOG = LoggerFactory.getLogger(EsNodeProvider.class);
    private final ElasticsearchConfiguration configuration;

    @Inject
    public EsNodeProvider(ElasticsearchConfiguration configuration) {
        this.configuration = configuration;
    }

    @Singleton
    public Node get() {
        NodeBuilder builder = NodeBuilder.nodeBuilder().client(this.configuration.isClientNode());
        Map<String, String> settings = EsNodeProvider.readNodeSettings(this.configuration);
        builder.settings().put(settings);
        return builder.build();
    }

    public static Map<String, String> readNodeSettings(ElasticsearchConfiguration conf) {
        HashMap settings = Maps.newHashMap();
        settings.put("cluster.name", conf.getClusterName());
        settings.put("node.name", conf.getNodeName());
        settings.put("node.master", Boolean.toString(conf.isMasterNode()));
        settings.put("node.data", Boolean.toString(conf.isDataNode()));
        if (!Strings.isNullOrEmpty((String)conf.getPathData())) {
            settings.put("path.data", conf.getPathData());
        }
        settings.put("action.auto_create_index", Boolean.toString(false));
        settings.put("http.enabled", Boolean.toString(conf.isHttpEnabled()));
        settings.put("transport.tcp.port", String.valueOf(conf.getTransportTcpPort()));
        settings.put("discovery.initial_state_timeout", conf.getInitialStateTimeout());
        settings.put("discovery.zen.ping.multicast.enabled", Boolean.toString(conf.isMulticastDiscovery()));
        if (conf.getUnicastHosts() != null && !conf.getUnicastHosts().isEmpty()) {
            ImmutableList.Builder trimmedHosts = ImmutableList.builder();
            for (String host : conf.getUnicastHosts()) {
                trimmedHosts.add((Object)host.trim());
            }
            settings.put("discovery.zen.ping.unicast.hosts", Joiner.on((String)",").join((Iterable)trimmedHosts.build()));
        }
        if (!Strings.isNullOrEmpty((String)conf.getNetworkHost())) {
            settings.put("network.host", conf.getNetworkHost());
        }
        if (!Strings.isNullOrEmpty((String)conf.getNetworkBindHost())) {
            settings.put("network.bind_host", conf.getNetworkBindHost());
        }
        if (!Strings.isNullOrEmpty((String)conf.getNetworkPublishHost())) {
            settings.put("network.publish_host", conf.getNetworkPublishHost());
        }
        settings.put("plugins.mandatory", "graylog2-monitor");
        File esConfigFile = conf.getConfigFile();
        if (esConfigFile != null) {
            try {
                byte[] esSettings = Files.readAllBytes(esConfigFile.toPath());
                settings.putAll(new YamlSettingsLoader().load(esSettings));
            }
            catch (IOException e) {
                LOG.warn("Cannot read Elasticsearch configuration.");
            }
        }
        return settings;
    }
}

