/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.mongodb.BasicDBObject;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.FieldChartWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.QuickvaluesWidget;
import org.graylog2.dashboards.widgets.SearchResultChartWidget;
import org.graylog2.dashboards.widgets.SearchResultCountWidget;
import org.graylog2.dashboards.widgets.StatisticalCountWidget;
import org.graylog2.dashboards.widgets.StreamSearchResultCountWidget;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.KeywordRange;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.models.dashboards.requests.AddWidgetRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DashboardWidgetCreator {
    private final MetricRegistry metricRegistry;
    private final WidgetCacheTime.Factory cacheTimeFactory;

    @Inject
    public DashboardWidgetCreator(MetricRegistry metricRegistry, WidgetCacheTime.Factory cacheTimeFactory) {
        this.metricRegistry = metricRegistry;
        this.cacheTimeFactory = cacheTimeFactory;
    }

    public DashboardWidget fromRequest(Searches searches, AddWidgetRequest awr, String userId) throws DashboardWidget.NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        return this.fromRequest(searches, null, awr, userId);
    }

    public DashboardWidget fromRequest(Searches searches, String widgetId, AddWidgetRequest awr, String userId) throws DashboardWidget.NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        TimeRange timeRange;
        DashboardWidget.Type type;
        try {
            type = DashboardWidget.Type.valueOf(awr.type().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new DashboardWidget.NoSuchWidgetTypeException("No such widget type <" + awr.type() + ">");
        }
        String id = Strings.isNullOrEmpty((String)widgetId) ? UUID.randomUUID().toString() : widgetId;
        String rangeType = (String)awr.config().get("range_type");
        if (rangeType == null) {
            throw new InvalidRangeParametersException("range_type not set");
        }
        switch (rangeType) {
            case "relative": {
                timeRange = new RelativeRange(Integer.parseInt((String)awr.config().get("range")));
                break;
            }
            case "keyword": {
                timeRange = new KeywordRange((String)awr.config().get("keyword"), true);
                break;
            }
            case "absolute": {
                timeRange = new AbsoluteRange((String)awr.config().get("from"), (String)awr.config().get("to"));
                break;
            }
            default: {
                throw new InvalidRangeParametersException("range_type not recognized");
            }
        }
        return this.buildDashboardWidget(type, searches, id, awr.description(), 0, awr.config(), (String)awr.config().get("query"), timeRange, userId);
    }

    public DashboardWidget fromPersisted(Searches searches, BasicDBObject fields) throws DashboardWidget.NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        TimeRange timeRange;
        DashboardWidget.Type type;
        try {
            type = DashboardWidget.Type.valueOf(((String)fields.get("type")).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new DashboardWidget.NoSuchWidgetTypeException();
        }
        BasicDBObject config = (BasicDBObject)fields.get("config");
        BasicDBObject timerangeConfig = (BasicDBObject)config.get("timerange");
        String rangeType = (String)timerangeConfig.get("type");
        if (rangeType == null) {
            throw new InvalidRangeParametersException("range type not set");
        }
        switch (rangeType) {
            case "relative": {
                timeRange = new RelativeRange((Integer)timerangeConfig.get("range"));
                break;
            }
            case "keyword": {
                timeRange = new KeywordRange((String)timerangeConfig.get("keyword"), true);
                break;
            }
            case "absolute": {
                String from = new DateTime(timerangeConfig.get("from"), DateTimeZone.UTC).toString("yyyy-MM-dd HH:mm:ss.SSS");
                String to = new DateTime(timerangeConfig.get("to"), DateTimeZone.UTC).toString("yyyy-MM-dd HH:mm:ss.SSS");
                timeRange = new AbsoluteRange(from, to);
                break;
            }
            default: {
                throw new InvalidRangeParametersException("range_type not recognized");
            }
        }
        String description = (String)fields.get("description");
        int cacheTime = (Integer)MoreObjects.firstNonNull((Object)fields.get("cache_time"), (Object)0);
        return this.buildDashboardWidget(type, searches, (String)fields.get("id"), description, cacheTime, (Map<String, Object>)config, (String)config.get("query"), timeRange, (String)fields.get("creator_user_id"));
    }

    public DashboardWidget buildDashboardWidget(DashboardWidget.Type type, Searches searches, String widgetId, String description, int requestedCacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) throws DashboardWidget.NoSuchWidgetTypeException, InvalidWidgetConfigurationException {
        WidgetCacheTime cacheTime = this.cacheTimeFactory.create(requestedCacheTime);
        switch (type) {
            case SEARCH_RESULT_COUNT: {
                return new SearchResultCountWidget(this.metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case STREAM_SEARCH_RESULT_COUNT: {
                return new StreamSearchResultCountWidget(this.metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case FIELD_CHART: {
                return new FieldChartWidget(this.metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case QUICKVALUES: {
                return new QuickvaluesWidget(this.metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case SEARCH_RESULT_CHART: {
                return new SearchResultChartWidget(this.metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case STATS_COUNT: {
                return new StatisticalCountWidget(this.metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
        }
        throw new DashboardWidget.NoSuchWidgetTypeException();
    }
}

