/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.indexer.results.TermsResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickvaluesWidget
extends DashboardWidget {
    private static final Logger LOG = LoggerFactory.getLogger(QuickvaluesWidget.class);
    private final String query;
    private final TimeRange timeRange;
    @Nullable
    private final String streamId;
    private final String field;
    private final Searches searches;
    private final Boolean showPieChart;
    private final Boolean showDataTable;

    public QuickvaluesWidget(MetricRegistry metricRegistry, Searches searches, String id, String description, WidgetCacheTime cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) throws InvalidWidgetConfigurationException {
        super(metricRegistry, DashboardWidget.Type.QUICKVALUES, id, description, cacheTime, config, creatorUserId);
        this.searches = searches;
        if (!this.checkConfig(config)) {
            throw new InvalidWidgetConfigurationException("Missing or invalid widget configuration. Provided config was: " + config.toString());
        }
        this.query = query;
        this.timeRange = timeRange;
        this.field = (String)config.get("field");
        this.streamId = (String)config.get("stream_id");
        this.showPieChart = config.get("show_pie_chart") != null && Boolean.parseBoolean(String.valueOf(config.get("show_pie_chart")));
        this.showDataTable = !config.containsKey("show_data_table") || Boolean.parseBoolean(String.valueOf(config.get("show_data_table")));
    }

    public String getQuery() {
        return this.query;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        ImmutableMap.Builder persistedConfig = ImmutableMap.builder().put((Object)"query", (Object)this.query).put((Object)"timerange", this.timeRange.getPersistedConfig()).put((Object)"field", (Object)this.field).put((Object)"show_pie_chart", (Object)this.showPieChart).put((Object)"show_data_table", (Object)this.showDataTable);
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            persistedConfig.put((Object)"stream_id", (Object)this.streamId);
        }
        return persistedConfig.build();
    }

    @Override
    protected ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        TermsResult terms = this.searches.terms(this.field, 50, this.query, filter, this.timeRange);
        HashMap result = Maps.newHashMap();
        result.put("terms", terms.getTerms());
        result.put("total", terms.getTotal());
        result.put("other", terms.getOther());
        result.put("missing", terms.getMissing());
        return new ComputationResult(result, terms.took().millis());
    }

    private boolean checkConfig(Map<String, Object> config) {
        return config.containsKey("field");
    }
}

