/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.events;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.mongodb.DBCollection;
import com.mongodb.WriteConcern;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.events.ClusterEvent;
import org.graylog2.plugin.periodical.Periodical;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterEventCleanupPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterEventCleanupPeriodical.class);
    private static final String COLLECTION_NAME = "cluster_events";
    @VisibleForTesting
    static final long DEFAULT_MAX_EVENT_AGE = TimeUnit.HOURS.toMillis(1L);
    private final JacksonDBCollection<ClusterEvent, String> dbCollection;
    private final long maxEventAge;

    @Inject
    public ClusterEventCleanupPeriodical(MongoJackObjectMapperProvider mapperProvider, MongoConnection mongoConnection) {
        this((JacksonDBCollection<ClusterEvent, String>)JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), ClusterEvent.class, String.class, (ObjectMapper)mapperProvider.get()), DEFAULT_MAX_EVENT_AGE);
    }

    ClusterEventCleanupPeriodical(JacksonDBCollection<ClusterEvent, String> dbCollection, long maxEventAge) {
        this.dbCollection = (JacksonDBCollection)Preconditions.checkNotNull(dbCollection);
        this.maxEventAge = maxEventAge;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return Ints.saturatedCast((long)TimeUnit.MINUTES.toSeconds(5L));
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void doRun() {
        try {
            LOG.debug("Removing stale events from MongoDB collection \"{}\"", (Object)COLLECTION_NAME);
            long timestamp = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.maxEventAge;
            DBQuery.Query query = DBQuery.lessThan((String)"timestamp", (Object)timestamp);
            WriteResult writeResult = this.dbCollection.remove(query, WriteConcern.FSYNCED);
            LOG.debug("Removed {} stale events from \"{}\"", (Object)writeResult.getN(), (Object)COLLECTION_NAME);
        }
        catch (Exception e) {
            LOG.warn("Error while removing stale cluster events from MongoDB", (Throwable)e);
        }
    }
}

