/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.mongodb.DBCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import oi.thekraken.grok.api.Grok;
import oi.thekraken.grok.api.exception.GrokException;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.plugin.database.ValidationException;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokPatternServiceImpl
implements GrokPatternService {
    public static final String GROK_PATTERNS = "grok_patterns";
    private static final Logger log = LoggerFactory.getLogger(GrokPatternServiceImpl.class);
    private final JacksonDBCollection<GrokPattern, ObjectId> dbCollection;

    @Inject
    protected GrokPatternServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(GROK_PATTERNS), GrokPattern.class, ObjectId.class, (ObjectMapper)mapper.get());
    }

    @Override
    public GrokPattern load(String patternId) throws NotFoundException {
        GrokPattern pattern = (GrokPattern)this.dbCollection.findOneById((Object)new ObjectId(patternId));
        if (pattern == null) {
            throw new NotFoundException();
        }
        return pattern;
    }

    @Override
    public Set<GrokPattern> loadAll() {
        DBCursor grokPatterns = this.dbCollection.find();
        HashSet patterns = Sets.newHashSet();
        Iterables.addAll((Collection)patterns, (Iterable)grokPatterns);
        return patterns;
    }

    @Override
    public GrokPattern save(GrokPattern pattern) throws ValidationException {
        if (!this.validate(pattern)) {
            throw new ValidationException("Invalid pattern " + pattern);
        }
        WriteResult result = this.dbCollection.save((Object)pattern);
        return (GrokPattern)result.getSavedObject();
    }

    @Override
    public List<GrokPattern> saveAll(Collection<GrokPattern> patterns, boolean replace) throws ValidationException {
        ImmutableList.Builder savedPatterns = ImmutableList.builder();
        if (replace) {
            this.deleteAll();
        }
        for (GrokPattern pattern : patterns) {
            savedPatterns.add((Object)this.save(pattern));
        }
        return savedPatterns.build();
    }

    @Override
    public boolean validate(GrokPattern pattern) {
        boolean fieldsMissing = !Strings.isNullOrEmpty((String)pattern.name) && !Strings.isNullOrEmpty((String)pattern.pattern);
        try {
            Grok grok = new Grok();
            grok.addPattern(pattern.name, pattern.pattern);
            grok.compile("%{" + pattern.name + "}");
        }
        catch (GrokException ignored) {
        }
        catch (PatternSyntaxException e) {
            log.warn("Invalid regular expression syntax for '" + pattern.name + "' with pattern " + pattern.pattern, (Throwable)e);
            return false;
        }
        return fieldsMissing;
    }

    @Override
    public int delete(String patternId) {
        return this.dbCollection.removeById((Object)new ObjectId(patternId)).getN();
    }

    @Override
    public int deleteAll() {
        return this.dbCollection.remove(DBQuery.empty()).getN();
    }
}

