/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.client.Client;

public class Mapping {
    public static PutMappingRequest getPutMappingRequest(Client client, String index, String analyzer, boolean storeTimestampsAsDocValues) {
        PutMappingRequestBuilder builder = client.admin().indices().preparePutMapping(new String[]{index});
        builder.setType("message");
        ImmutableMap mapping = ImmutableMap.of((Object)"properties", Mapping.partFieldProperties(analyzer, storeTimestampsAsDocValues), (Object)"dynamic_templates", Mapping.partDefaultAllInDynamicTemplate(), (Object)"_source", Mapping.enabledAndCompressed(), (Object)"_ttl", Mapping.enabled());
        ImmutableMap completeMapping = ImmutableMap.of((Object)"message", (Object)mapping);
        builder.setSource((Map)completeMapping);
        return (PutMappingRequest)builder.request();
    }

    private static List<Map<String, Map<String, Object>>> partDefaultAllInDynamicTemplate() {
        ImmutableMap notAnalyzed = ImmutableMap.of((Object)"index", (Object)"not_analyzed");
        ImmutableMap defaultAll = ImmutableMap.of((Object)"match", (Object)"*", (Object)"mapping", (Object)notAnalyzed);
        ImmutableMap template = ImmutableMap.of((Object)"store_generic", (Object)defaultAll);
        return ImmutableList.of((Object)template);
    }

    private static Map<String, Map<String, ? extends Serializable>> partFieldProperties(String analyzer, boolean storeTimestampsAsDocValues) {
        return ImmutableMap.of((Object)"message", Mapping.analyzedString(analyzer), (Object)"full_message", Mapping.analyzedString(analyzer), (Object)"timestamp", Mapping.typeTimeWithMillis(storeTimestampsAsDocValues), (Object)"source", Mapping.analyzedString("analyzer_keyword"));
    }

    private static Map<String, String> analyzedString(String analyzer) {
        return ImmutableMap.of((Object)"index", (Object)"analyzed", (Object)"type", (Object)"string", (Object)"analyzer", (Object)analyzer);
    }

    private static Map<String, Serializable> typeTimeWithMillis(boolean storeTimestampsAsDocValues) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"type", (Object)"date").put((Object)"format", (Object)"yyyy-MM-dd HH:mm:ss.SSS");
        if (storeTimestampsAsDocValues) {
            builder.put((Object)"doc_values", (Object)true);
        }
        return builder.build();
    }

    private static Map<String, Boolean> enabled() {
        return ImmutableMap.of((Object)"enabled", (Object)true);
    }

    private static Map<String, Boolean> enabledAndCompressed() {
        return ImmutableMap.of((Object)"enabled", (Object)true, (Object)"compress", (Object)true);
    }
}

