/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.indexer.PersistedDeadLetter;
import org.graylog2.indexer.PersistedDeadLetterImpl;
import org.graylog2.indexer.PersistedDeadLetterService;
import org.joda.time.DateTime;

public class PersistedDeadLetterServiceImpl
extends PersistedServiceImpl
implements PersistedDeadLetterService {
    @Inject
    public PersistedDeadLetterServiceImpl(MongoConnection mongoConnection) {
        super(mongoConnection);
    }

    @Override
    public PersistedDeadLetter create(String letterId, DateTime timestamp, Map<String, Object> message) {
        return this.create(new ObjectId().toHexString(), letterId, timestamp, message);
    }

    @Override
    public PersistedDeadLetter create(String id, String letterId, DateTime timestamp, Map<String, Object> message) {
        HashMap doc = Maps.newHashMap();
        doc.put("letter_id", letterId);
        doc.put("timestamp", timestamp);
        doc.put("message", message);
        return new PersistedDeadLetterImpl(new ObjectId(id), doc);
    }

    @Override
    public long count() {
        return this.count(PersistedDeadLetterImpl.class, (DBObject)new BasicDBObject());
    }
}

