/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.messages;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequestBuilder;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.indices.IndexMissingException;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.DeadLetter;
import org.graylog2.indexer.messages.DocumentNotFoundException;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.plugin.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Messages {
    public static final String TYPE = "message";
    private static final Logger log = LoggerFactory.getLogger(Messages.class);
    private final Client c;
    private final ElasticsearchConfiguration configuration;
    private LinkedBlockingQueue<List<DeadLetter>> deadLetterQueue;

    @Inject
    public Messages(Client client, ElasticsearchConfiguration configuration) {
        this.configuration = configuration;
        this.c = client;
        this.deadLetterQueue = new LinkedBlockingQueue(1000);
    }

    public LinkedBlockingQueue<List<DeadLetter>> getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public ResultMessage get(String messageId, String index) throws IndexMissingException, DocumentNotFoundException {
        GetRequestBuilder grb = new GetRequestBuilder(this.c, index);
        grb.setId(messageId);
        GetResponse r = (GetResponse)this.c.get((GetRequest)grb.request()).actionGet();
        if (!r.isExists()) {
            throw new DocumentNotFoundException();
        }
        return ResultMessage.parseFromSource(r);
    }

    public List<String> analyze(String string, String index) throws IndexMissingException {
        ArrayList tokens = Lists.newArrayList();
        AnalyzeRequestBuilder arb = new AnalyzeRequestBuilder(this.c.admin().indices(), index, string);
        AnalyzeResponse r = (AnalyzeResponse)this.c.admin().indices().analyze((AnalyzeRequest)arb.request()).actionGet();
        for (AnalyzeResponse.AnalyzeToken token : r.getTokens()) {
            tokens.add(token.getTerm());
        }
        return tokens;
    }

    public boolean bulkIndex(List<Message> messages) {
        if (messages.isEmpty()) {
            return true;
        }
        BulkRequestBuilder request = this.c.prepareBulk();
        for (Message msg : messages) {
            request.add(this.buildIndexRequest(this.configuration.getIndexPrefix() + "_" + "deflector", msg.toElasticSearchObject(), msg.getId()));
        }
        request.setConsistencyLevel(WriteConsistencyLevel.ONE);
        request.setReplicationType(ReplicationType.ASYNC);
        BulkResponse response = (BulkResponse)this.c.bulk((BulkRequest)request.request()).actionGet();
        log.debug("Deflector index: Bulk indexed {} messages, took {} ms, failures: {}", new Object[]{response.getItems().length, response.getTookInMillis(), response.hasFailures()});
        if (response.hasFailures()) {
            this.propagateFailure(response.getItems(), messages, response.buildFailureMessage());
        }
        return !response.hasFailures();
    }

    private void propagateFailure(BulkItemResponse[] items, List<Message> messages, String errorMessage) {
        log.error("Failed to index [{}] messages. Please check the index error log in your web interface for the reason. Error: {}", (Object)items.length, (Object)errorMessage);
        ArrayList deadLetters = Lists.newArrayList();
        for (BulkItemResponse item : items) {
            if (!item.isFailed()) continue;
            deadLetters.add(new DeadLetter(item, messages.get(item.getItemId())));
        }
        boolean r = this.deadLetterQueue.offer(deadLetters);
        if (!r) {
            log.debug("Could not propagate failure to failure queue. Queue is full.");
        }
    }

    private IndexRequestBuilder buildIndexRequest(String index, Map<String, Object> source, String id) {
        IndexRequestBuilder b = new IndexRequestBuilder(this.c);
        b.setId(id);
        b.setSource(source);
        b.setIndex(index);
        b.setContentType(XContentType.JSON);
        b.setOpType(IndexRequest.OpType.INDEX);
        b.setType(TYPE);
        b.setConsistencyLevel(WriteConsistencyLevel.ONE);
        return b;
    }
}

