/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;

public class DateHistogramResult
extends HistogramResult {
    private final DateHistogram result;
    private final Searches.DateHistogramInterval interval;

    public DateHistogramResult(DateHistogram result, String originalQuery, BytesReference builtQuery, Searches.DateHistogramInterval interval, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.result = result;
        this.interval = interval;
    }

    @Override
    public Searches.DateHistogramInterval getInterval() {
        return this.interval;
    }

    @Override
    public Map<Long, Long> getResults() {
        TreeMap results = Maps.newTreeMap();
        for (DateHistogram.Bucket bucket : this.result.getBuckets()) {
            results.put(bucket.getKeyAsDate().getMillis() / 1000L, bucket.getDocCount());
        }
        return results;
    }
}

