/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation;

import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.indices.IndexStatistics;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;

@Singleton
public class SizeBasedRotationStrategy
implements RotationStrategy {
    private final Indices indices;
    private final long maxSize;

    @Inject
    public SizeBasedRotationStrategy(ElasticsearchConfiguration configuration, Indices indices) {
        this.indices = indices;
        this.maxSize = configuration.getMaxSizePerIndex();
    }

    @Nullable
    public RotationStrategy.Result shouldRotate(final String index) {
        IndexStatistics indexStats = this.indices.getIndexStats(index);
        if (indexStats == null) {
            return null;
        }
        final long sizeInBytes = indexStats.getPrimaries().store.getSizeInBytes();
        final boolean shouldRotate = sizeInBytes > this.maxSize;
        return new RotationStrategy.Result(){
            public final MessageFormat ROTATE = new MessageFormat("Storage size for index <{0}> is {1} bytes, exceeding the maximum of {2} bytes. Rotating index.");
            public final MessageFormat NOT_ROTATE = new MessageFormat("Storage size for index <{0}> is {1} bytes, below the maximum of {2} bytes. Not doing anything.");

            public String getDescription() {
                MessageFormat format = this.shouldRotate() ? this.ROTATE : this.NOT_ROTATE;
                return format.format(new Object[]{index, sizeInBytes, SizeBasedRotationStrategy.this.maxSize});
            }

            public boolean shouldRotate() {
                return shouldRotate;
            }
        };
    }
}

