/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.initializers;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.client.Client;
import org.elasticsearch.node.Node;
import org.graylog2.UI;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.initializers.BufferSynchronizerService;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IndexerSetupService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(IndexerSetupService.class);
    private static final Version MINIMUM_ES_VERSION = Version.V_1_3_4;
    private static final Version MAXIMUM_ES_VERSION = Version.fromString((String)"1.5.99");
    private final Node node;
    private final ElasticsearchConfiguration configuration;
    private final BufferSynchronizerService bufferSynchronizerService;
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;

    @Inject
    public IndexerSetupService(Node node, ElasticsearchConfiguration configuration, BufferSynchronizerService bufferSynchronizerService, @Named(value="systemHttpClient") OkHttpClient httpClient, MetricRegistry metricRegistry) {
        this(node, configuration, bufferSynchronizerService, httpClient, new ObjectMapper(), metricRegistry);
    }

    @VisibleForTesting
    IndexerSetupService(Node node, ElasticsearchConfiguration configuration, BufferSynchronizerService bufferSynchronizerService, OkHttpClient httpClient, ObjectMapper objectMapper, MetricRegistry metricRegistry) {
        this.node = node;
        this.configuration = configuration;
        this.bufferSynchronizerService = bufferSynchronizerService;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        bufferSynchronizerService.addListener(new Service.Listener(){

            public void terminated(Service.State from) {
                LOG.debug("Shutting down ES client after buffer synchronizer has terminated.");
                IndexerSetupService.this.node.close();
            }
        }, this.executorService(metricRegistry));
    }

    private ExecutorService executorService(MetricRegistry metricRegistry) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("indexer-setup-service-%d").build();
        return new InstrumentedExecutorService(Executors.newSingleThreadExecutor(threadFactory), metricRegistry, MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"executor-service"}));
    }

    protected void startUp() throws Exception {
        Tools.silenceUncaughtExceptionsInThisThread();
        LOG.debug("Starting indexer");
        try {
            this.node.start();
            Client client = this.node.client();
            try {
                ClusterHealthRequest atLeastRed = new ClusterHealthRequest(new String[0]).waitForStatus(ClusterHealthStatus.RED);
                ClusterHealthResponse health = (ClusterHealthResponse)client.admin().cluster().health(atLeastRed).actionGet(this.configuration.getClusterDiscoveryTimeout(), TimeUnit.MILLISECONDS);
                if (ClusterHealthStatus.RED.equals((Object)health.getStatus())) {
                    UI.exitHardWithWall("The Elasticsearch cluster state is RED which means shards are unassigned. This usually indicates a crashed and corrupt cluster and needs to be investigated. Graylog will shut down.", "http://docs.graylog.org/en/1.0/pages/configuring_es.html");
                }
            }
            catch (ElasticsearchTimeoutException e) {
                String hosts = this.node.settings().get("discovery.zen.ping.unicast.hosts");
                if (!Strings.isNullOrEmpty((String)hosts)) {
                    Iterable hostList = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)hosts);
                    for (String host : hostList) {
                        URI esUri = URI.create("http://" + HostAndPort.fromString((String)host).getHostText() + ":9200/");
                        LOG.info("Checking Elasticsearch HTTP API at {}", (Object)esUri);
                        try {
                            Request request = new Request.Builder().get().url(esUri.resolve("/_nodes").toString()).build();
                            Response response = this.httpClient.newCall(request).execute();
                            if (response.isSuccessful()) {
                                JsonNode resultTree = this.objectMapper.readTree(response.body().byteStream());
                                JsonNode nodesList = resultTree.get("nodes");
                                if (!this.configuration.isDisableVersionCheck()) {
                                    Iterator nodes = nodesList.fieldNames();
                                    while (nodes.hasNext()) {
                                        String id = (String)nodes.next();
                                        Version clusterVersion = Version.fromString((String)nodesList.get(id).get("version").textValue());
                                        this.checkClusterVersion(clusterVersion);
                                    }
                                }
                                String clusterName = resultTree.get("cluster_name").textValue();
                                this.checkClusterName(clusterName);
                                continue;
                            }
                            LOG.error("Could not connect to Elasticsearch at " + esUri + ". Is it running?");
                        }
                        catch (IOException ioException) {
                            LOG.error("Could not connect to Elasticsearch.", (Throwable)ioException);
                        }
                    }
                }
                UI.exitHardWithWall("Could not successfully connect to Elasticsearch, if you use multicast check that it is working in your network and that Elasticsearch is running properly and is reachable. Also check that the cluster.name setting is correct.", "http://docs.graylog.org/en/1.0/pages/configuring_es.html");
            }
        }
        catch (Exception e) {
            this.bufferSynchronizerService.setIndexerUnavailable();
            throw e;
        }
    }

    private void checkClusterVersion(Version clusterVersion) {
        if (!clusterVersion.onOrAfter(MINIMUM_ES_VERSION) && !clusterVersion.onOrBefore(MAXIMUM_ES_VERSION)) {
            LOG.error("Elasticsearch node is of the wrong version {}, it must be between {} and {}! Please make sure you are running the correct version of Elasticsearch.", new Object[]{clusterVersion, MINIMUM_ES_VERSION, MAXIMUM_ES_VERSION});
        }
    }

    private void checkClusterName(String clusterName) {
        if (!this.node.settings().get("cluster.name").equals(clusterName)) {
            LOG.error("Elasticsearch cluster name is different, Graylog uses `{}`, Elasticsearch cluster uses `{}`. Please check the `cluster.name` setting of both Graylog and Elasticsearch.", (Object)this.node.settings().get("cluster.name"), (Object)clusterName);
        }
    }

    protected void shutDown() throws Exception {
    }
}

