/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import java.util.Map;
import org.graylog2.ConfigurationException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.inputs.Converter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateConverter
extends Converter {
    private static final Logger LOG = LoggerFactory.getLogger(DateConverter.class);
    private final String dateFormat;

    public DateConverter(Map<String, Object> config) throws ConfigurationException {
        super(Converter.Type.DATE, config);
        if (config.get("date_format") == null || ((String)config.get("date_format")).isEmpty()) {
            throw new ConfigurationException("Missing config [date_format].");
        }
        this.dateFormat = ((String)config.get("date_format")).trim();
    }

    public Object convert(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        DateTime localNow = Tools.iso8601();
        LOG.debug("Trying to parse date <{}> with pattern <{}>.", (Object)value, (Object)this.dateFormat);
        return DateTime.parse((String)value, (DateTimeFormatter)DateTimeFormat.forPattern((String)this.dateFormat).withDefaultYear(localNow.getYear()));
    }

    public boolean buildsMultipleFields() {
        return false;
    }
}

