/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import java.util.List;
import java.util.Map;
import org.graylog2.plugin.inputs.Converter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class FlexibleDateConverter
extends Converter {
    private final DateTimeZone timeZone;

    public FlexibleDateConverter(Map<String, Object> config) {
        super(Converter.Type.FLEXDATE, config);
        this.timeZone = FlexibleDateConverter.buildTimeZone(config.get("time_zone"));
    }

    private static DateTimeZone buildTimeZone(Object timeZoneId) {
        if (timeZoneId instanceof String) {
            try {
                String timeZoneString = (String)timeZoneId;
                String zoneId = (String)MoreObjects.firstNonNull((Object)Strings.emptyToNull((String)timeZoneString.trim()), (Object)"Etc/UTC");
                return DateTimeZone.forID((String)zoneId);
            }
            catch (IllegalArgumentException e) {
                return DateTimeZone.forID((String)"Etc/UTC");
            }
        }
        return DateTimeZone.forID((String)"Etc/UTC");
    }

    public Object convert(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        Parser parser = new Parser(this.timeZone.toTimeZone());
        List r = parser.parse(value);
        if (r.isEmpty() || ((DateGroup)r.get(0)).getDates().isEmpty()) {
            return null;
        }
        return new DateTime(((DateGroup)r.get(0)).getDates().get(0), this.timeZone);
    }

    public boolean buildsMultipleFields() {
        return false;
    }
}

