/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import java.util.UUID;
import javax.inject.Inject;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterIdGeneratorPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterIdGeneratorPeriodical.class);
    private final ClusterConfigService clusterConfigService;

    @Inject
    public ClusterIdGeneratorPeriodical(ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
    }

    public boolean runsForever() {
        return true;
    }

    public boolean stopOnGracefulShutdown() {
        return false;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 0;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void doRun() {
        if (this.clusterConfigService.get(ClusterId.class) == null) {
            ClusterId clusterId = ClusterId.create((String)UUID.randomUUID().toString());
            this.clusterConfigService.write((Object)clusterId);
            LOG.debug("Generated cluster ID {}", (Object)clusterId.clusterId());
        }
    }
}

