/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import javax.inject.Inject;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerClusterCheckerThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexerClusterCheckerThread.class);
    private static final int MINIMUM_OPEN_FILES_LIMIT = 64000;
    private final NotificationService notificationService;
    private final Cluster cluster;

    @Inject
    public IndexerClusterCheckerThread(NotificationService notificationService, Cluster cluster) {
        this.notificationService = notificationService;
        this.cluster = cluster;
    }

    public void doRun() {
        if (!this.notificationService.isFirst(Notification.Type.ES_OPEN_FILES)) {
            return;
        }
        try {
            this.cluster.health().getStatus();
        }
        catch (Exception e) {
            LOG.info("Indexer not fully initialized yet. Skipping periodic cluster check.");
            return;
        }
        boolean allHigher = true;
        for (NodeInfo node : this.cluster.getDataNodes()) {
            long maxFileDescriptors = node.getProcess().getMaxFileDescriptors();
            String osName = (String)node.getJvm().getSystemProperties().get("os.name");
            if (null != osName && osName.startsWith("Windows")) {
                LOG.debug("Skipping open file limit check for Indexer node <{}> on Windows", (Object)node.getNode().getName());
                continue;
            }
            if (maxFileDescriptors == -1L || maxFileDescriptors >= 64000L) continue;
            Notification notification = this.notificationService.buildNow().addType(Notification.Type.ES_OPEN_FILES).addSeverity(Notification.Severity.URGENT).addDetail("hostname", node.getHostname()).addDetail("max_file_descriptors", maxFileDescriptors);
            if (this.notificationService.publishIfFirst(notification)) {
                LOG.warn("Indexer node <{}> open file limit is too low: [{}]. Set it to at least {}.", new Object[]{node.getNode().getName(), maxFileDescriptors, 64000});
            }
            allHigher = false;
        }
        if (allHigher) {
            Notification notification = this.notificationService.build().addType(Notification.Type.ES_OPEN_FILES);
            this.notificationService.fixed(notification);
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 30;
    }
}

