/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.primitives.Ints;
import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.collectors.CollectorService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeExpiredCollectorsThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeExpiredCollectorsThread.class);
    private final CollectorService collectorService;
    private final Configuration configuration;

    @Inject
    public PurgeExpiredCollectorsThread(CollectorService collectorService, Configuration configuration) {
        this.collectorService = collectorService;
        this.configuration = configuration;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 3600;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void doRun() {
        Duration threshold = this.configuration.getCollectorExpirationThreshold();
        int purgedCollectors = this.collectorService.destroyExpired(Ints.checkedCast((long)threshold.getQuantity()), threshold.getUnit());
        LOG.debug("Purged {} inactive collectors.", (Object)purgedCollectors);
    }
}

