/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.sources;

import com.codahale.metrics.annotation.Timed;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.indexer.InvalidRangeFormatException;
import org.graylog2.indexer.results.TermsResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.rest.models.sources.responses.SourcesList;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@RequiresPermissions(value={"sources:read"})
@Api(value="Sources", description="Listing message sources (e.g. hosts sending logs)")
@Path(value="/sources")
public class SourcesResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SourcesResource.class);
    private static final String CACHE_KEY = "sources_list";
    private static final Cache<String, TermsResult> CACHE = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private final Searches searches;

    @Inject
    public SourcesResource(Searches searches) {
        this.searches = searches;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all sources (not more than 5000) that have messages in the current indices. The result is cached for 10 seconds.", notes="Range: The parameter is in seconds relative to the current time. 86400 means 'in the last day',0 is special and means 'across all indices'")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid range parameter provided.")})
    @Produces(value={"application/json"})
    public SourcesList list(final @ApiParam(name="range", value="Relative timeframe to search in. See method description.", required=true) @QueryParam(value="range") @Min(value=0L) int range) {
        TermsResult sources;
        try {
            sources = (TermsResult)CACHE.get((Object)(CACHE_KEY + range), (Callable)new Callable<TermsResult>(){

                @Override
                public TermsResult call() throws Exception {
                    try {
                        return SourcesResource.this.searches.terms("source", 5000, "*", new RelativeRange(range));
                    }
                    catch (InvalidRangeFormatException | InvalidRangeParametersException e) {
                        throw new ExecutionException(e);
                    }
                }
            });
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRangeParametersException) {
                LOG.error("Invalid relative time range value.", (Throwable)e);
                throw new BadRequestException("Invalid time range " + range, (Throwable)e);
            }
            LOG.error("Could not calculate list of sources.", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
        return SourcesList.create((int)sources.getTerms().size(), sources.getTerms(), (long)sources.took().millis(), (int)range);
    }
}

