/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.ranges.RebuildIndexRangesJob;
import org.graylog2.rest.resources.system.responses.IndexRangesResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.jobs.SystemJobConcurrencyException;
import org.graylog2.system.jobs.SystemJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/IndexRanges", description="Index timeranges")
@Path(value="/system/indices/ranges")
public class IndexRangesResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRangesResource.class);
    private final IndexRangeService indexRangeService;
    private final RebuildIndexRangesJob.Factory rebuildIndexRangesJobFactory;
    private final Deflector deflector;
    private final SystemJobManager systemJobManager;

    @Inject
    public IndexRangesResource(IndexRangeService indexRangeService, RebuildIndexRangesJob.Factory rebuildIndexRangesJobFactory, Deflector deflector, SystemJobManager systemJobManager) {
        this.indexRangeService = indexRangeService;
        this.rebuildIndexRangesJobFactory = rebuildIndexRangesJobFactory;
        this.deflector = deflector;
        this.systemJobManager = systemJobManager;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all index ranges")
    @Produces(value={"application/json"})
    public IndexRangesResponse list() {
        ArrayList ranges = Lists.newArrayList();
        for (IndexRange range : this.indexRangeService.getFrom(0)) {
            if (!this.isPermitted("indexranges:read", range.getIndexName())) continue;
            ranges.add(range);
        }
        return IndexRangesResponse.create(ranges.size(), ranges);
    }

    @POST
    @Timed
    @Path(value="/rebuild")
    @RequiresPermissions(value={"indexranges:rebuild"})
    @ApiOperation(value="Rebuild/sync index range information.", notes="This triggers a systemjob that scans every index and stores meta information about what indices contain messages in what timeranges. It atomically overwrites already existing meta information.")
    @ApiResponses(value={@ApiResponse(code=202, message="Rebuild/sync systemjob triggered.")})
    @Produces(value={"application/json"})
    public Response rebuild() {
        RebuildIndexRangesJob rebuildJob = this.rebuildIndexRangesJobFactory.create(this.deflector);
        try {
            this.systemJobManager.submit(rebuildJob);
        }
        catch (SystemJobConcurrencyException e) {
            LOG.error("Concurrency level of this job reached: " + e.getMessage());
            throw new ForbiddenException();
        }
        return Response.accepted().build();
    }
}

