/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.system.sessions.requests.SessionCreateRequest;
import org.graylog2.rest.models.system.sessions.responses.SessionResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.graylog2.shared.users.UserService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/system/sessions")
@Api(value="System/Sessions", description="Login for interactive user sessions")
public class SessionsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SessionsResource.class);
    private final UserService userService;
    private final DefaultSecurityManager securityManager;

    @Inject
    public SessionsResource(UserService userService, DefaultSecurityManager securityManager) {
        this.userService = userService;
        this.securityManager = securityManager;
    }

    @POST
    @ApiOperation(value="Create a new session", notes="This request creates a new session for a user or reactivates an existing session: the equivalent of logging in.")
    public SessionResponse newSession(@Context ContainerRequestContext requestContext, @ApiParam(name="Login request", value="Username and credentials", required=true) @Valid @NotNull SessionCreateRequest createRequest) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (!(securityContext instanceof ShiroSecurityContext)) {
            throw new InternalServerErrorException("Unsupported SecurityContext class, this is a bug!");
        }
        ShiroSecurityContext shiroSecurityContext = (ShiroSecurityContext)securityContext;
        String sessionId = shiroSecurityContext.getUsername();
        Object id = null;
        if (sessionId != null && !sessionId.isEmpty()) {
            id = sessionId;
        }
        Subject subject = new Subject.Builder().sessionId((Serializable)id).buildSubject();
        ThreadContext.bind((Subject)subject);
        try {
            subject.login((AuthenticationToken)new UsernamePasswordToken(createRequest.username(), createRequest.password()));
            User user = this.userService.load(createRequest.username());
            if (user != null) {
                long timeoutInMillis = user.getSessionTimeoutMs();
                subject.getSession().setTimeout(timeoutInMillis);
            } else {
                subject.getSession().setTimeout(TimeUnit.HOURS.toMillis(8L));
            }
            subject.getSession().touch();
            ((DefaultSecurityManager)SecurityUtils.getSecurityManager()).getSubjectDAO().save(subject);
        }
        catch (AuthenticationException e) {
            LOG.warn("Unable to log in user " + createRequest.username(), (Throwable)e);
        }
        catch (UnknownSessionException e) {
            subject.logout();
        }
        if (subject.isAuthenticated()) {
            Session session = subject.getSession();
            id = session.getId();
            return SessionResponse.create((Date)new DateTime((Object)session.getLastAccessTime(), DateTimeZone.UTC).plus(session.getTimeout()).toDate(), (String)id.toString());
        }
        throw new NotAuthorizedException("Invalid username or password", (Object)"Basic realm=\"Graylog Server session\"", new Object[0]);
    }

    @DELETE
    @ApiOperation(value="Terminate an existing session", notes="Destroys the session with the given ID: the equivalent of logging out.")
    @Path(value="/{sessionId}")
    @RequiresAuthentication
    public void terminateSession(@ApiParam(name="sessionId", required=true) @PathParam(value="sessionId") String sessionId) {
        Subject subject = this.getSubject();
        this.securityManager.logout(subject);
        Session session = subject.getSession(false);
        if (session == null || !session.getId().equals(sessionId)) {
            throw new NotFoundException();
        }
    }
}

